/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.equilibrium;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import org.jetbrains.annotations.NotNull;

public enum Equilibrium {
    EQUALS(Objects::equals, "=", "=="),
    NOT_EQUALS((leftObject, rightObject) -> !leftObject.equals(rightObject), "!="),
    BIGGER((leftObject, rightObject) -> {
        if (!(leftObject instanceof Number) || !(rightObject instanceof Number)) {
            return false;
        }
        Number left = (Number)leftObject;
        Number right = (Number)rightObject;
        if (left instanceof Double) {
            return left.doubleValue() > right.doubleValue();
        }
        if (left instanceof Integer) {
            return left.intValue() > right.intValue();
        }
        if (left instanceof Long) {
            return left.longValue() > right.longValue();
        }
        if (left instanceof Float) {
            return left.floatValue() > right.floatValue();
        }
        if (left instanceof Short) {
            return left.shortValue() > right.shortValue();
        }
        if (left instanceof Byte) {
            return left.byteValue() > right.byteValue();
        }
        return false;
    }, ">"),
    BIGGER_AND_EQUALS((leftObject, rightObject) -> {
        if (!(leftObject instanceof Number) || !(rightObject instanceof Number)) {
            return false;
        }
        Number left = (Number)leftObject;
        Number right = (Number)rightObject;
        if (left instanceof Double) {
            return left.doubleValue() >= right.doubleValue();
        }
        if (left instanceof Integer) {
            return left.intValue() >= right.intValue();
        }
        if (left instanceof Long) {
            return left.longValue() >= right.longValue();
        }
        if (left instanceof Float) {
            return left.floatValue() >= right.floatValue();
        }
        if (left instanceof Short) {
            return left.shortValue() >= right.shortValue();
        }
        if (left instanceof Byte) {
            return left.byteValue() >= right.byteValue();
        }
        return false;
    }, "=>", ">="),
    LESS((leftObject, rightObject) -> {
        if (!(leftObject instanceof Number) || !(rightObject instanceof Number)) {
            return false;
        }
        Number left = (Number)leftObject;
        Number right = (Number)rightObject;
        if (left instanceof Double) {
            return left.doubleValue() < right.doubleValue();
        }
        if (left instanceof Integer) {
            return left.intValue() < right.intValue();
        }
        if (left instanceof Long) {
            return left.longValue() < right.longValue();
        }
        if (left instanceof Float) {
            return left.floatValue() < right.floatValue();
        }
        if (left instanceof Short) {
            return left.shortValue() < right.shortValue();
        }
        if (left instanceof Byte) {
            return left.byteValue() < right.byteValue();
        }
        return false;
    }, "<"),
    LESS_OR_EQUALS((leftObject, rightObject) -> {
        if (!(leftObject instanceof Number) || !(rightObject instanceof Number)) {
            return false;
        }
        Number left = (Number)leftObject;
        Number right = (Number)rightObject;
        if (left instanceof Double) {
            return left.doubleValue() <= right.doubleValue();
        }
        if (left instanceof Integer) {
            return left.intValue() <= right.intValue();
        }
        if (left instanceof Long) {
            return left.longValue() <= right.longValue();
        }
        if (left instanceof Float) {
            return left.floatValue() <= right.floatValue();
        }
        if (left instanceof Short) {
            return left.shortValue() <= right.shortValue();
        }
        if (left instanceof Byte) {
            return left.byteValue() <= right.byteValue();
        }
        return false;
    }, "<=", "=<"),
    INSTANCE_OF((leftObject, rightObject) -> {
        if (!(leftObject instanceof Class) || !(rightObject instanceof Class)) {
            return false;
        }
        return ((Class)rightObject).isAssignableFrom((Class)leftObject);
    }, "is", "instance of"),
    NOT_INSTANCE_OF((leftObject, rightObject) -> {
        if (!(leftObject instanceof Class) || !(rightObject instanceof Class)) {
            return false;
        }
        return !((Class)rightObject).isAssignableFrom((Class)leftObject);
    }, "isnt", "isn't", "isnot", "is not", "not instance of"),
    NOTHING((leftObject, rightObject) -> false, new String[0]);

    @NotNull
    private final List<String> operators;
    @NotNull
    private final BiPredicate<Object, Object> predicate;

    private Equilibrium(List<String> operators, BiPredicate<Object, Object> predicate) {
        this.operators = operators;
        this.predicate = predicate;
    }

    private Equilibrium(BiPredicate<Object, Object> predicate, String ... operators) {
        this(Arrays.asList(operators), predicate);
    }

    @NotNull
    public static Equilibrium fromString(@NotNull String operator) {
        return Arrays.stream(Equilibrium.values()).filter(equilibrium -> equilibrium.getOperators().contains(operator)).findFirst().orElse(NOTHING);
    }

    public boolean control(@NotNull Object leftObject, @NotNull Object rightObject) {
        return this.predicate.test(leftObject, rightObject);
    }

    @NotNull
    public List<String> getOperators() {
        return Collections.unmodifiableList(this.operators);
    }
}

