/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.jsongration;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simpleyaml.configuration.ConfigurationSection;

final class Helper {
    static void convertMapToSection(@NotNull JsonObject object, @NotNull ConfigurationSection section) {
        Helper.convertMapToSection(Helper.jsonObjectAsMap(object), section);
    }

    @NotNull
    static JsonObject mapAsJsonObject(@NotNull Map<?, ?> map) {
        JsonObject object = new JsonObject();
        map.forEach((key, value) -> Helper.objectAsJsonValue(value).ifPresent(jsonValue -> object.add(String.valueOf(key), (JsonValue)jsonValue)));
        return object;
    }

    @Nullable
    private static Object parseNumber(@NotNull JsonValue number) {
        try {
            return number.asInt();
        }
        catch (NumberFormatException e) {
            try {
                return number.asLong();
            }
            catch (NumberFormatException e1) {
                try {
                    return number.asDouble();
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
        }
    }

    private static void convertMapToSection(@NotNull Map<?, ?> input, @NotNull ConfigurationSection section) {
        Map<String, Object> result = Helper.deserialize(input);
        for (Map.Entry<String, Object> entry : result.entrySet()) {
            String key = entry.getKey().toString();
            Object value = entry.getValue();
            if (value instanceof Map) {
                Helper.convertMapToSection((Map)value, section.createSection(key));
                continue;
            }
            section.set(key, value);
        }
    }

    @NotNull
    private static Collection<Object> deserialize(@NotNull Iterable<?> input) {
        ArrayList<Object> objects = new ArrayList<Object>();
        input.forEach(o -> {
            if (o instanceof Map) {
                objects.add(Helper.deserialize((Map)o));
            } else if (o instanceof List) {
                objects.add(Helper.deserialize((Iterable)o));
            } else {
                objects.add(o);
            }
        });
        return objects;
    }

    @NotNull
    private static Map<String, Object> deserialize(@NotNull Map<?, ?> input) {
        return input.entrySet().stream().collect(Collectors.toMap(entry -> Objects.toString(entry.getKey()), entry -> {
            Object value = entry.getValue();
            if (value instanceof Map) {
                return Helper.deserialize((Map)value);
            }
            if (value instanceof Iterable) {
                return Helper.deserialize((Iterable)value);
            }
            if (value instanceof Stream) {
                return Helper.deserialize(((Stream)value).collect(Collectors.toList()));
            }
            return value;
        }));
    }

    @NotNull
    private static Map<String, Object> jsonObjectAsMap(@NotNull JsonObject object) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        object.forEach(member -> Helper.jsonValueAsObject(member.getValue()).ifPresent(o -> map.put(member.getName(), o)));
        return map;
    }

    @NotNull
    private static Optional<Object> jsonValueAsObject(@NotNull JsonValue value) {
        Object object = value.isBoolean() ? Boolean.valueOf(value.asBoolean()) : (value.isNumber() ? Helper.parseNumber(value) : (value.isString() ? value.asString() : (value.isArray() ? Helper.jsonArrayAsList(value.asArray()) : (value.isObject() ? Helper.jsonObjectAsMap(value.asObject()) : null))));
        return Optional.ofNullable(object);
    }

    @NotNull
    private static List<Object> jsonArrayAsList(@NotNull JsonArray array) {
        ArrayList<Object> list = new ArrayList<Object>(array.size());
        array.forEach(element -> Helper.jsonValueAsObject(element).ifPresent(list::add));
        return list;
    }

    @NotNull
    private static Optional<JsonValue> objectAsJsonValue(@NotNull Object object) {
        JsonValue value = object instanceof Boolean ? Json.value((Boolean)object) : (object instanceof Integer ? Json.value((Integer)object) : (object instanceof Long ? Json.value((Long)object) : (object instanceof Float ? Json.value(((Float)object).floatValue()) : (object instanceof Double ? Json.value((Double)object) : (object instanceof String ? Json.value((String)object) : (object instanceof Iterable ? Helper.collectionAsJsonArray((Iterable)object) : (object instanceof Map ? Helper.mapAsJsonObject((Map)object) : (object instanceof ConfigurationSection ? Helper.mapAsJsonObject(((ConfigurationSection)object).getValues(false)) : null))))))));
        return Optional.ofNullable(value);
    }

    @NotNull
    private static JsonArray collectionAsJsonArray(@NotNull Iterable<?> collection) {
        JsonArray array = new JsonArray();
        collection.forEach(o -> Helper.objectAsJsonValue(o).ifPresent(array::add));
        return array;
    }

    private Helper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

