/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.jsongration;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonValue;
import com.eclipsesource.json.WriterConfig;
import io.github.portlek.jsongration.Helper;
import io.github.portlek.jsongration.JsonConfigurationOptions;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.simpleyaml.configuration.ConfigurationSection;
import org.simpleyaml.configuration.file.FileConfiguration;

public final class JsonConfiguration
extends FileConfiguration {
    private static final String BLANK_CONFIG = "{}\n";

    public static JsonConfiguration loadConfiguration(@NotNull File file) {
        return JsonConfiguration.loadConfiguration(new JsonConfiguration(), file);
    }

    private static JsonConfiguration loadConfiguration(@NotNull JsonConfiguration config, @NotNull File file) {
        config.load(file);
        return config;
    }

    @Override
    @NotNull
    public String saveToString() {
        String dump = Helper.mapAsJsonObject(this.getValues(false)).toString(WriterConfig.PRETTY_PRINT);
        if (dump.equals(BLANK_CONFIG)) {
            return "";
        }
        return dump;
    }

    @Override
    public void loadFromString(@NotNull String contents) {
        if (contents.isEmpty()) {
            return;
        }
        JsonValue parse = Json.parse(contents);
        if (!parse.isObject()) {
            return;
        }
        Helper.convertMapToSection(parse.asObject(), (ConfigurationSection)this);
    }

    @Override
    @NotNull
    public JsonConfigurationOptions options() {
        if (this.options == null) {
            this.options = new JsonConfigurationOptions(this);
        }
        return (JsonConfigurationOptions)this.options;
    }

    @Override
    protected String buildHeader() {
        return "";
    }
}

