/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.bukkitlocation;

import java.util.Locale;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.util.NumberConversions;
import org.jetbrains.annotations.NotNull;

public final class LocationUtil {
    private static final Pattern PATTERN = Pattern.compile("(?<world>[^/]+):(?<x>[\\-0-9.]+),(?<y>[\\-0-9.]+),(?<z>[\\-0-9.]+)(:(?<yaw>[\\-0-9.]+):(?<pitch>[\\-0-9.]+))?");

    private LocationUtil() {
    }

    @NotNull
    public static Location centeredOn(@NotNull Location location) {
        return LocationUtil.centered(location, 0.1);
    }

    @NotNull
    public static Location centeredIn(@NotNull Location location) {
        return LocationUtil.centered(location, 0.5);
    }

    @NotNull
    public static World validWorld(@NotNull Location location) {
        return Optional.ofNullable(location.getWorld()).orElseThrow(() -> new IllegalStateException("World of the location cannot be null!"));
    }

    @NotNull
    public static Optional<Location> fromKey(@NotNull String key) {
        Matcher match = PATTERN.matcher(key.replace("_", ".").replace("/", ":"));
        if (match.matches()) {
            World world = Bukkit.getWorld((String)match.group("world"));
            double x = NumberConversions.toDouble((Object)match.group("x"));
            double y = NumberConversions.toDouble((Object)match.group("y"));
            double z = NumberConversions.toDouble((Object)match.group("z"));
            Float yaw = Optional.ofNullable(match.group("yaw")).map(NumberConversions::toFloat).orElse(Float.valueOf(0.0f));
            Float pitch = Optional.ofNullable(match.group("pitch")).map(NumberConversions::toFloat).orElse(Float.valueOf(0.0f));
            return Optional.of(new Location(world, x, y, z, yaw.floatValue(), pitch.floatValue()));
        }
        return Optional.empty();
    }

    @NotNull
    public static String toKey(@NotNull Location location) {
        String s = LocationUtil.validWorld(location).getName() + ':';
        s = s + String.format(Locale.ENGLISH, "%.2f,%.2f,%.2f", location.getX(), location.getY(), location.getZ());
        if (location.getYaw() != 0.0f || location.getPitch() != 0.0f) {
            s = s + String.format(Locale.ENGLISH, ":%.2f:%.2f", Float.valueOf(location.getYaw()), Float.valueOf(location.getPitch()));
        }
        return s.replace(":", "/").replace(".", "_");
    }

    @NotNull
    private static Location centered(@NotNull Location location, double yPlus) {
        return new Location(LocationUtil.validWorld(location), location.getX() + 0.5, location.getY() + yPlus, location.getZ() + 0.5, location.getYaw(), location.getPitch());
    }
}

