/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.bukkitlocation;

import io.github.portlek.bukkitlocation.LocationUtil;
import io.github.portlek.bukkitlocation.RandomUtil;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.jetbrains.annotations.NotNull;

public final class Cuboid {
    @NotNull
    private final Location minimumLocation;
    @NotNull
    private final Location maximumLocation;
    @NotNull
    private final World world;
    private final double minX;
    private final double minY;
    private final double minZ;
    private final double maxX;
    private final double maxY;
    private final double maxZ;

    public Cuboid(@NotNull Location minimumLocation, @NotNull Location maximumLocation) {
        World minimumWorld = LocationUtil.validWorld(minimumLocation);
        World maximumWorld = LocationUtil.validWorld(maximumLocation);
        if (!minimumWorld.equals(maximumWorld)) {
            throw new IllegalStateException(minimumWorld + " and " + maximumWorld + " are not equals!");
        }
        this.minimumLocation = minimumLocation;
        this.maximumLocation = maximumLocation;
        this.world = minimumWorld;
        this.minX = Math.min(minimumLocation.getX(), maximumLocation.getX());
        this.minY = Math.min(minimumLocation.getX(), maximumLocation.getX());
        this.minZ = Math.min(minimumLocation.getX(), maximumLocation.getX());
        this.maxX = Math.max(minimumLocation.getX(), maximumLocation.getX());
        this.maxY = Math.max(minimumLocation.getX(), maximumLocation.getX());
        this.maxZ = Math.max(minimumLocation.getX(), maximumLocation.getX());
    }

    @NotNull
    public Location getMinimumLocation() {
        return this.minimumLocation;
    }

    @NotNull
    public Location getMaximumLocation() {
        return this.maximumLocation;
    }

    @NotNull
    public List<Block> blocks() {
        ArrayList<Block> result = new ArrayList<Block>();
        for (double x = this.minX; x <= this.maxX; x += 1.0) {
            for (double y = this.minY; y <= this.maxY; y += 1.0) {
                for (double z = this.minZ; z <= this.maxZ; z += 1.0) {
                    result.add(this.world.getBlockAt(new Location(this.world, x, y, z)));
                }
            }
        }
        return result;
    }

    @NotNull
    public List<Location> locations() {
        ArrayList<Location> result = new ArrayList<Location>();
        for (double x = this.minX; x <= this.maxX; x += 1.0) {
            for (double y = this.minY; y <= this.maxY; y += 1.0) {
                for (double z = this.minZ; z <= this.maxZ; z += 1.0) {
                    result.add(new Location(this.world, x, y, z));
                }
            }
        }
        return result;
    }

    public void set(@NotNull Material material) {
        this.blocks().forEach(block -> block.setType(material));
    }

    @NotNull
    public Location centerBottom() {
        return new Location(this.world, this.minX + (this.maxX - this.minX) / 2.0, this.minY, this.minZ + (this.maxZ - this.minZ) / 2.0);
    }

    @NotNull
    public Location center() {
        return new Location(this.world, this.minX + (this.maxX - this.minX) / 2.0, this.minY + (this.maxY - this.minY) / 2.0, this.minZ + (this.maxZ - this.minZ) / 2.0);
    }

    public boolean isIn(@NotNull Location location) {
        return location.getX() >= this.minX && location.getX() <= this.maxX && this.minY <= location.getY() && location.getY() <= this.maxY && this.minZ <= location.getZ() && location.getZ() <= this.maxZ;
    }

    public void removeAll() {
        this.blocks().forEach(block -> block.setType(Material.AIR));
    }

    @NotNull
    public List<Block> randomBlocks(int limit, boolean duplicate) {
        return RandomUtil.chooseRandoms(this.blocks(), limit, duplicate);
    }

    @NotNull
    public List<Location> randomLocations(int limit, boolean duplicate) {
        return RandomUtil.chooseRandoms(this.locations(), limit, duplicate);
    }
}

