/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.smartinventory.listener;

import io.github.portlek.smartinventory.Icon;
import io.github.portlek.smartinventory.InventoryContents;
import io.github.portlek.smartinventory.SmartInventory;
import io.github.portlek.smartinventory.event.IcDragEvent;
import io.github.portlek.smartinventory.util.SlotPos;
import java.util.Iterator;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;

public final class InventoryDragListener
implements Listener {
    @EventHandler(priority=EventPriority.LOW)
    public void onInventoryDrag(InventoryDragEvent event) {
        SmartInventory.getHolder(event.getWhoClicked().getUniqueId()).ifPresent(holder -> {
            Inventory inventory = event.getInventory();
            InventoryContents contents = holder.getContents();
            Iterator iterator = event.getRawSlots().iterator();
            while (iterator.hasNext()) {
                int slot = (Integer)iterator.next();
                SlotPos pos = SlotPos.of(slot / 9, slot % 9);
                contents.get(pos).ifPresent(icon -> icon.accept(new IcDragEvent(holder.getPlugin(), event, contents, (Icon)icon)));
                if (slot >= inventory.getSize() || contents.isEditable(pos)) continue;
                event.setCancelled(true);
                break;
            }
        });
    }
}

