/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.smartinventory.event;

import io.github.portlek.smartinventory.InventoryContents;
import io.github.portlek.smartinventory.event.abs.PageClickEvent;
import org.bukkit.Bukkit;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class PgClickEvent
implements PageClickEvent {
    @NotNull
    private final InventoryContents contents;
    @NotNull
    private final InventoryClickEvent event;
    @NotNull
    private final Plugin plugin;

    public PgClickEvent(@NotNull Plugin plugin, @NotNull InventoryClickEvent event, @NotNull InventoryContents contents) {
        this.plugin = plugin;
        this.event = event;
        this.contents = contents;
    }

    @Override
    public void cancel() {
        this.event.setCancelled(true);
    }

    @Override
    public void close() {
        Bukkit.getScheduler().runTask(this.plugin, () -> this.contents.page().close(this.contents.player()));
    }

    @Override
    @NotNull
    public InventoryContents contents() {
        return this.contents;
    }

    @Override
    @NotNull
    public InventoryClickEvent getEvent() {
        return this.event;
    }
}

