/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.smartinventory.manager;

import io.github.portlek.smartinventory.InventoryOpener;
import io.github.portlek.smartinventory.SmartInventory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

public final class BasicSmartInventory
implements SmartInventory {
    private final Collection<InventoryOpener> openers = new ArrayList<InventoryOpener>();
    @NotNull
    private final Plugin plugin;
    private final Map<UUID, BukkitRunnable> tasks = new ConcurrentHashMap<UUID, BukkitRunnable>();

    public BasicSmartInventory(@NotNull Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    @NotNull
    public Collection<InventoryOpener> getOpeners() {
        return Collections.unmodifiableCollection(this.openers);
    }

    @Override
    @NotNull
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    @NotNull
    public Map<UUID, BukkitRunnable> getTasks() {
        return Collections.unmodifiableMap(this.tasks);
    }

    @Override
    public void registerOpeners(InventoryOpener ... openers) {
        this.openers.addAll(Arrays.asList(openers));
    }

    @Override
    public void removeTask(@NotNull UUID uniqueId) {
        this.tasks.remove(uniqueId);
    }

    @Override
    public void setTask(@NotNull UUID uniqueId, @NotNull BukkitRunnable task) {
        this.tasks.put(uniqueId, task);
    }

    @Override
    public void unregisterOpeners(InventoryOpener ... openers) {
        this.openers.removeAll(Arrays.asList(openers));
    }

    static {
        try {
            Class.forName("io.github.portlek.smartinventory.event.PlgnDisableEvent");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}

