/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.smartinventory.listener;

import io.github.portlek.smartinventory.Page;
import io.github.portlek.smartinventory.SmartInventory;
import io.github.portlek.smartinventory.event.PgCloseEvent;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;

public final class InventoryCloseListener
implements Listener {
    @NotNull
    private final Consumer<UUID> stopTickFunction;

    public InventoryCloseListener(@NotNull Consumer<UUID> stopTickFunction) {
        this.stopTickFunction = stopTickFunction;
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        SmartInventory.getHolder(event.getPlayer().getUniqueId()).ifPresent(holder -> {
            Inventory inventory = event.getInventory();
            Page page = holder.getPage();
            PgCloseEvent close = new PgCloseEvent(holder.getContents());
            page.accept(close);
            if (!page.canClose(close)) {
                Bukkit.getScheduler().runTask(holder.getPlugin(), () -> event.getPlayer().openInventory(inventory));
                return;
            }
            inventory.clear();
            this.stopTickFunction.accept(event.getPlayer().getUniqueId());
        });
    }
}

