/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.smartinventory;

import io.github.portlek.smartinventory.InventoryContents;
import io.github.portlek.smartinventory.InventoryOpener;
import io.github.portlek.smartinventory.InventoryProvider;
import io.github.portlek.smartinventory.Page;
import io.github.portlek.smartinventory.SmartHolder;
import io.github.portlek.smartinventory.event.PgTickEvent;
import io.github.portlek.smartinventory.listener.InventoryClickListener;
import io.github.portlek.smartinventory.listener.InventoryCloseListener;
import io.github.portlek.smartinventory.listener.InventoryDragListener;
import io.github.portlek.smartinventory.listener.InventoryOpenListener;
import io.github.portlek.smartinventory.listener.PlayerQuitListener;
import io.github.portlek.smartinventory.listener.PluginDisableListener;
import io.github.portlek.smartinventory.opener.ChestInventoryOpener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

public interface SmartInventory {
    public static final List<InventoryOpener> DEFAULT_OPENERS = Collections.singletonList(new ChestInventoryOpener());
    public static final Function<Consumer<UUID>, List<Listener>> LISTENERS = function -> Arrays.asList(new InventoryClickListener(), new InventoryOpenListener(), new InventoryCloseListener((Consumer<UUID>)function), new PlayerQuitListener((Consumer<UUID>)function), new PluginDisableListener(), new InventoryDragListener());

    @NotNull
    public static Optional<SmartHolder> getHolder(@NotNull UUID uniqueId) {
        return Optional.ofNullable(Bukkit.getPlayer((UUID)uniqueId)).flatMap(SmartInventory::getHolder);
    }

    @NotNull
    public static Optional<SmartHolder> getHolder(@NotNull Player player) {
        InventoryHolder holder = player.getOpenInventory().getTopInventory().getHolder();
        if (!(holder instanceof SmartHolder)) {
            return Optional.empty();
        }
        return Optional.of((SmartHolder)holder).filter(SmartHolder::isActive);
    }

    @NotNull
    public static List<SmartHolder> getHolders() {
        return Bukkit.getOnlinePlayers().stream().map(SmartInventory::getHolder).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    @NotNull
    public static List<Player> getOpenedPlayers(@NotNull Page page) {
        return SmartInventory.getHolders().stream().filter(holder -> page.id().equals(holder.getPage().id())).map(SmartHolder::getPlayer).collect(Collectors.toList());
    }

    public static void notifyUpdate(@NotNull Player player) {
        SmartInventory.getHolder(player).ifPresent(smartHolder -> smartHolder.getContents().notifyUpdate());
    }

    public static <T extends InventoryProvider> void notifyUpdateForAll(@NotNull Class<T> provider) {
        SmartInventory.getHolders().stream().map(SmartHolder::getContents).filter(contents -> provider.equals(contents.page().provider().getClass())).forEach(InventoryContents::notifyUpdate);
    }

    public static void notifyUpdateForAllById(@NotNull String id) {
        SmartInventory.getHolders().stream().map(SmartHolder::getPage).filter(page -> page.id().equals(id)).forEach(Page::notifyUpdateForAll);
    }

    @NotNull
    default public Optional<InventoryOpener> findOpener(@NotNull InventoryType type) {
        return Stream.of(this.getOpeners(), DEFAULT_OPENERS).flatMap(Collection::stream).filter(opener -> opener.supports(type)).findFirst();
    }

    @NotNull
    public Collection<InventoryOpener> getOpeners();

    @NotNull
    public Plugin getPlugin();

    @NotNull
    default public Optional<BukkitRunnable> getTask(@NotNull UUID uniqueId) {
        return Optional.ofNullable(this.getTasks().get(uniqueId));
    }

    @NotNull
    public Map<UUID, BukkitRunnable> getTasks();

    default public void init() {
        LISTENERS.apply(this::stopTick).forEach(listener -> Bukkit.getPluginManager().registerEvents(listener, this.getPlugin()));
    }

    public void registerOpeners(InventoryOpener ... var1);

    public void removeTask(@NotNull UUID var1);

    public void setTask(@NotNull UUID var1, @NotNull BukkitRunnable var2);

    default public void stopTick(@NotNull UUID uniqueId) {
        this.getTask(uniqueId).ifPresent(runnable -> {
            Bukkit.getScheduler().cancelTask(runnable.getTaskId());
            this.removeTask(uniqueId);
        });
    }

    default public void tick(final @NotNull UUID uniqueId, final @NotNull Page page) {
        BukkitRunnable task = new BukkitRunnable(){

            public void run() {
                SmartInventory.getHolder(uniqueId).map(SmartHolder::getContents).ifPresent(contents -> {
                    page.accept(new PgTickEvent((InventoryContents)contents));
                    page.provider().tick((InventoryContents)contents);
                });
            }
        };
        this.setTask(uniqueId, task);
        if (page.async()) {
            task.runTaskTimerAsynchronously(this.getPlugin(), page.startDelay(), page.tick());
        } else {
            task.runTaskTimer(this.getPlugin(), page.startDelay(), page.tick());
        }
    }

    public void unregisterOpeners(InventoryOpener ... var1);
}

