/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.observer.source;

import io.github.portlek.observer.Source;
import io.github.portlek.observer.Target;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public final class BasicSource<T>
implements Source<T> {
    private final Collection<Target<T>> subscriptions = new ArrayList<Target<T>>();

    @Override
    public void subscribe(@NotNull Target<T> target) {
        if (!this.subscriptions.contains(target)) {
            this.subscriptions.add(target);
        }
    }

    @Override
    public void unsubscribe(@NotNull Target<T> target) {
        this.subscriptions.remove(target);
    }

    @Override
    public void notifyTargets(@NotNull T argument) {
        this.subscriptions.forEach(target -> target.update(argument));
    }
}

