/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.smartinventory.page;

import io.github.portlek.observer.Source;
import io.github.portlek.observer.source.BasicSource;
import io.github.portlek.smartinventory.Handle;
import io.github.portlek.smartinventory.InventoryContents;
import io.github.portlek.smartinventory.InventoryOpener;
import io.github.portlek.smartinventory.InventoryProvider;
import io.github.portlek.smartinventory.Page;
import io.github.portlek.smartinventory.SmartInventory;
import io.github.portlek.smartinventory.content.BasicInventoryContents;
import io.github.portlek.smartinventory.event.PgCloseEvent;
import io.github.portlek.smartinventory.event.PgInitEvent;
import io.github.portlek.smartinventory.event.PgUpdateEvent;
import io.github.portlek.smartinventory.event.abs.CloseEvent;
import io.github.portlek.smartinventory.event.abs.PageEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BasicPage
implements Page {
    private final Source<InventoryContents> source = new BasicSource<InventoryContents>();
    private final Collection<Handle<? extends PageEvent>> handles = new ArrayList<Handle<? extends PageEvent>>();
    @NotNull
    private final SmartInventory inventory;
    @NotNull
    private final InventoryType type = InventoryType.CHEST;
    @NotNull
    private InventoryProvider provider;
    @NotNull
    private String title = "Smart Inventory";
    private int row = 1;
    private int column = 9;
    private long tick = 1L;
    private long startDelay = 1L;
    private boolean async = false;
    private boolean tickEnable = true;
    @NotNull
    private String id = "none";
    @NotNull
    private Predicate<CloseEvent> canClose = event -> true;
    @Nullable
    private Page parent;

    public BasicPage(@NotNull SmartInventory inventory, @NotNull InventoryProvider provider) {
        this.inventory = inventory;
        this.provider = provider;
    }

    public BasicPage(@NotNull SmartInventory inventory) {
        this(inventory, InventoryProvider.EMPTY);
    }

    @Override
    @NotNull
    public <T extends PageEvent> Page handle(@NotNull Handle<T> handle) {
        this.handles.add(handle);
        return this;
    }

    @Override
    public void notifyUpdate(@NotNull InventoryContents contents) {
        this.accept(new PgUpdateEvent(contents));
        this.source.notifyTargets(contents);
    }

    @Override
    public <T extends PageEvent> void accept(@NotNull T event) {
        this.handles.stream().filter(handle -> handle.type().isAssignableFrom(event.getClass())).map(handle -> handle).forEach(handle -> handle.accept(event));
    }

    @Override
    @NotNull
    public InventoryProvider provider() {
        return this.provider;
    }

    @Override
    @NotNull
    public Page provider(@NotNull InventoryProvider provider) {
        this.provider = provider;
        return this;
    }

    @Override
    @NotNull
    public SmartInventory inventory() {
        return this.inventory;
    }

    @Override
    public long tick() {
        return this.tick;
    }

    @Override
    @NotNull
    public Page tick(long tick) {
        this.tick = tick;
        return this;
    }

    @Override
    public long startDelay() {
        return this.startDelay;
    }

    @Override
    @NotNull
    public Page startDelay(long startDelay) {
        this.startDelay = startDelay;
        return this;
    }

    @Override
    public boolean async() {
        return this.async;
    }

    @Override
    @NotNull
    public Page async(boolean async) {
        this.async = async;
        return this;
    }

    @Override
    public boolean tickEnable() {
        return this.tickEnable;
    }

    @Override
    @NotNull
    public Page tickEnable(boolean tickEnable) {
        this.tickEnable = tickEnable;
        return this;
    }

    @Override
    public int row() {
        return this.row;
    }

    @Override
    @NotNull
    public Page row(int row) {
        this.row = row;
        return this;
    }

    @Override
    public int column() {
        return this.column;
    }

    @Override
    @NotNull
    public Page column(int column) {
        this.column = column;
        return this;
    }

    @Override
    @NotNull
    public String title() {
        return this.title;
    }

    @Override
    @NotNull
    public Page title(@NotNull String title) {
        this.title = title;
        return this;
    }

    @Override
    @NotNull
    public Optional<Page> parent() {
        return Optional.ofNullable(this.parent);
    }

    @Override
    @NotNull
    public Page parent(@NotNull Page parent) {
        this.parent = parent;
        return this;
    }

    @Override
    @NotNull
    public Page id(@NotNull String id) {
        this.id = id;
        return this;
    }

    @Override
    @NotNull
    public String id() {
        return this.id;
    }

    @Override
    public boolean canClose(@NotNull CloseEvent event) {
        return this.canClose.test(event);
    }

    @Override
    @NotNull
    public Page canClose(@NotNull Predicate<CloseEvent> predicate) {
        this.canClose = predicate;
        return this;
    }

    @Override
    @NotNull
    public Inventory open(@NotNull Player player, int page, @NotNull Map<String, Object> properties) {
        this.close(player);
        InventoryOpener opener = this.inventory().findOpener(this.type).orElseThrow(() -> new IllegalStateException("No opener found for the inventory type " + this.type.name()));
        this.source.subscribe(this.provider());
        BasicInventoryContents contents = new BasicInventoryContents(this, player);
        contents.pagination().page(page);
        properties.forEach(contents::setProperty);
        this.inventory().setContents(player, contents);
        this.accept(new PgInitEvent(contents));
        this.provider().init(contents);
        Inventory opened = opener.open(this, player);
        this.inventory().setContentsByInventory(opened, contents);
        this.inventory().setPage(player, this);
        if (this.tickEnable()) {
            this.inventory().tick(player, this);
        }
        return opened;
    }

    @Override
    public void close(@NotNull Player player) {
        this.inventory().getContents(player).map(PgCloseEvent::new).ifPresent(this::accept);
        this.inventory().stopTick(player);
        this.inventory().removePage(player);
        this.inventory().removeContent(player);
        this.inventory().removeContentByInventory(player.getOpenInventory().getTopInventory());
        this.source.unsubscribe(this.provider());
        player.closeInventory();
    }
}

