/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.smartinventory.manager;

import io.github.portlek.smartinventory.InventoryContents;
import io.github.portlek.smartinventory.InventoryOpener;
import io.github.portlek.smartinventory.Page;
import io.github.portlek.smartinventory.SmartInventory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

public final class BasicSmartInventory
implements SmartInventory {
    private final Map<Player, Page> lastPages = new ConcurrentHashMap<Player, Page>();
    private final Map<Player, Page> pages = new ConcurrentHashMap<Player, Page>();
    private final Map<Player, InventoryContents> contents = new ConcurrentHashMap<Player, InventoryContents>();
    private final Map<Inventory, InventoryContents> contentsByInventory = new ConcurrentHashMap<Inventory, InventoryContents>();
    private final Map<Player, BukkitRunnable> tasks = new ConcurrentHashMap<Player, BukkitRunnable>();
    private final Collection<InventoryOpener> openers = new ArrayList<InventoryOpener>();
    @NotNull
    private final Plugin plugin;

    public BasicSmartInventory(@NotNull Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    @NotNull
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    @NotNull
    public Collection<InventoryOpener> getOpeners() {
        return Collections.unmodifiableCollection(this.openers);
    }

    @Override
    @NotNull
    public Map<Player, Page> getLastPages() {
        return Collections.unmodifiableMap(this.lastPages);
    }

    @Override
    @NotNull
    public Map<Player, Page> getPages() {
        return Collections.unmodifiableMap(this.pages);
    }

    @Override
    @NotNull
    public Map<Player, InventoryContents> getContents() {
        return Collections.unmodifiableMap(this.contents);
    }

    @Override
    @NotNull
    public Map<Inventory, InventoryContents> getContentsByInventory() {
        return Collections.unmodifiableMap(this.contentsByInventory);
    }

    @Override
    @NotNull
    public Optional<Page> getPage(@NotNull Player player) {
        return Optional.ofNullable(this.pages.get(player));
    }

    @Override
    @NotNull
    public Optional<Page> getLastPage(@NotNull Player player) {
        return Optional.ofNullable(this.lastPages.get(player));
    }

    @Override
    @NotNull
    public Optional<InventoryContents> getContents(@NotNull Player player) {
        return Optional.ofNullable(this.contents.get(player));
    }

    @Override
    @NotNull
    public Optional<InventoryContents> getContentsByInventory(@NotNull Inventory inventory) {
        return Optional.ofNullable(this.contentsByInventory.get(inventory));
    }

    @Override
    @NotNull
    public Optional<BukkitRunnable> getTask(@NotNull Player player) {
        return Optional.ofNullable(this.tasks.get(player));
    }

    @Override
    public void setPage(@NotNull Player player, @NotNull Page page) {
        this.pages.put(player, page);
        this.lastPages.put(player, page);
    }

    @Override
    public void setContents(@NotNull Player player, @NotNull InventoryContents contest) {
        this.contents.put(player, contest);
    }

    @Override
    public void setContentsByInventory(@NotNull Inventory inventory, @NotNull InventoryContents contest) {
        this.contentsByInventory.put(inventory, contest);
    }

    @Override
    public void setTask(@NotNull Player player, @NotNull BukkitRunnable task) {
        this.tasks.put(player, task);
    }

    @Override
    public void removePage(@NotNull Player player) {
        this.pages.remove(player);
    }

    @Override
    public void removeLastPage(@NotNull Player player) {
        this.lastPages.remove(player);
    }

    @Override
    public void removeContent(@NotNull Player player) {
        this.contents.remove(player);
    }

    @Override
    public void removeContentByInventory(@NotNull Inventory inventory) {
        this.contentsByInventory.remove(inventory);
    }

    @Override
    public void removeTask(@NotNull Player player) {
        this.tasks.remove(player);
    }

    @Override
    public void clearPages() {
        this.pages.clear();
    }

    @Override
    public void clearLastPages() {
        this.lastPages.clear();
    }

    @Override
    public void clearContents() {
        this.contents.clear();
    }

    @Override
    public void clearContentsByInventory() {
        this.contentsByInventory.clear();
    }

    @Override
    public void clearTask() {
        this.tasks.clear();
    }

    @Override
    public void registerOpeners(InventoryOpener ... openers) {
        this.openers.addAll(Arrays.asList(openers));
    }
}

