/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.smartinventory.listener;

import io.github.portlek.smartinventory.Icon;
import io.github.portlek.smartinventory.InventoryContents;
import io.github.portlek.smartinventory.SmartInventory;
import io.github.portlek.smartinventory.event.IcDragEvent;
import io.github.portlek.smartinventory.util.SlotPos;
import java.util.Iterator;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.jetbrains.annotations.NotNull;

public final class InventoryDragListener
implements Listener {
    @NotNull
    private final SmartInventory inventory;

    public InventoryDragListener(@NotNull SmartInventory inventory) {
        this.inventory = inventory;
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onInventoryDrag(InventoryDragEvent event) {
        Player player = (Player)event.getWhoClicked();
        this.inventory.getContents(player).ifPresent(contents -> {
            Iterator iterator = event.getRawSlots().iterator();
            while (iterator.hasNext()) {
                int slot = (Integer)iterator.next();
                SlotPos pos = SlotPos.of(slot / 9, slot % 9);
                contents.get(pos).ifPresent(icon -> icon.accept(new IcDragEvent(this.inventory.getPlugin(), event, (InventoryContents)contents, (Icon)icon)));
                if (slot >= player.getOpenInventory().getTopInventory().getSize() || contents.isEditable(pos)) continue;
                event.setCancelled(true);
                break;
            }
        });
    }
}

