/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.smartinventory;

import io.github.portlek.smartinventory.Handle;
import io.github.portlek.smartinventory.InventoryContents;
import io.github.portlek.smartinventory.InventoryProvider;
import io.github.portlek.smartinventory.SmartInventory;
import io.github.portlek.smartinventory.event.abs.BottomClickEvent;
import io.github.portlek.smartinventory.event.abs.CloseEvent;
import io.github.portlek.smartinventory.event.abs.InitEvent;
import io.github.portlek.smartinventory.event.abs.OpenEvent;
import io.github.portlek.smartinventory.event.abs.OutsideClickEvent;
import io.github.portlek.smartinventory.event.abs.PageClickEvent;
import io.github.portlek.smartinventory.event.abs.PageEvent;
import io.github.portlek.smartinventory.event.abs.TickEvent;
import io.github.portlek.smartinventory.event.abs.UpdateEvent;
import io.github.portlek.smartinventory.page.BasicPage;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;

public interface Page {
    public static Page build(@NotNull SmartInventory inventory, @NotNull InventoryProvider provider) {
        return new BasicPage(inventory, provider);
    }

    public static Page build(@NotNull SmartInventory inventory) {
        return new BasicPage(inventory);
    }

    @NotNull
    default public Page whenClose(@NotNull Consumer<CloseEvent> consumer) {
        return this.whenClose(consumer, Collections.emptyList());
    }

    @NotNull
    default public Page whenClose(@NotNull Consumer<CloseEvent> consumer, @NotNull List<Predicate<CloseEvent>> requirements) {
        return this.handle(CloseEvent.class, consumer, requirements);
    }

    @NotNull
    default public Page whenOpen(@NotNull Consumer<OpenEvent> consumer) {
        return this.whenOpen(consumer, Collections.emptyList());
    }

    @NotNull
    default public Page whenOpen(@NotNull Consumer<OpenEvent> consumer, @NotNull List<Predicate<OpenEvent>> requirements) {
        return this.handle(OpenEvent.class, consumer, requirements);
    }

    @NotNull
    default public Page whenInit(@NotNull Consumer<InitEvent> consumer) {
        return this.whenInit(consumer, Collections.emptyList());
    }

    @NotNull
    default public Page whenInit(@NotNull Consumer<InitEvent> consumer, @NotNull List<Predicate<InitEvent>> requirements) {
        return this.handle(InitEvent.class, consumer, requirements);
    }

    @NotNull
    default public Page whenUpdate(@NotNull Consumer<UpdateEvent> consumer) {
        return this.whenUpdate(consumer, Collections.emptyList());
    }

    @NotNull
    default public Page whenUpdate(@NotNull Consumer<UpdateEvent> consumer, @NotNull List<Predicate<UpdateEvent>> requirements) {
        return this.handle(UpdateEvent.class, consumer, requirements);
    }

    @NotNull
    default public Page whenTick(@NotNull Consumer<TickEvent> consumer) {
        return this.whenTick(consumer, Collections.emptyList());
    }

    @NotNull
    default public Page whenTick(@NotNull Consumer<TickEvent> consumer, @NotNull List<Predicate<TickEvent>> requirements) {
        return this.handle(TickEvent.class, consumer, requirements);
    }

    @NotNull
    default public Page whenBottomClick(@NotNull Consumer<BottomClickEvent> consumer) {
        return this.whenBottomClick(consumer, Collections.emptyList());
    }

    @NotNull
    default public Page whenBottomClick(@NotNull Consumer<BottomClickEvent> consumer, @NotNull List<Predicate<BottomClickEvent>> requirements) {
        return this.handle(BottomClickEvent.class, consumer, requirements);
    }

    @NotNull
    default public Page whenOutsideClick(@NotNull Consumer<OutsideClickEvent> consumer) {
        return this.whenOutsideClick(consumer, Collections.emptyList());
    }

    @NotNull
    default public Page whenOutsideClick(@NotNull Consumer<OutsideClickEvent> consumer, @NotNull List<Predicate<OutsideClickEvent>> requirements) {
        return this.handle(OutsideClickEvent.class, consumer, requirements);
    }

    @NotNull
    default public Page whenEmptyClick(@NotNull Consumer<PageClickEvent> consumer) {
        return this.whenEmptyClick(consumer, Collections.emptyList());
    }

    @NotNull
    default public Page whenEmptyClick(@NotNull Consumer<PageClickEvent> consumer, @NotNull List<Predicate<PageClickEvent>> requirements) {
        return this.handle(PageClickEvent.class, consumer, requirements);
    }

    @NotNull
    default public <T extends PageEvent> Page handle(@NotNull Class<T> clazz, @NotNull Consumer<T> consumer, @NotNull List<Predicate<T>> requirements) {
        return this.handle(Handle.from(clazz, consumer, requirements));
    }

    @NotNull
    public <T extends PageEvent> Page handle(@NotNull Handle<T> var1);

    @NotNull
    default public Page canClose(boolean canClose) {
        return this.canClose((CloseEvent event) -> canClose);
    }

    default public void open(@NotNull Player player) {
        this.open(player, 0);
    }

    default public void open(@NotNull Player player, int page) {
        this.open(player, page, Collections.emptyMap());
    }

    default public void open(@NotNull Player player, @NotNull Map<String, Object> properties) {
        this.open(player, 0, properties);
    }

    default public boolean checkBounds(int row, int column) {
        if (row >= 0) {
            return column >= 0;
        }
        if (row < this.row()) {
            return column < this.column();
        }
        return false;
    }

    default public void notifyUpdateForAll() {
        this.inventory().notifyUpdateForAll(this.provider().getClass());
    }

    default public void notifyUpdateForAllById() {
        this.inventory().notifyUpdateForAllById(this.id());
    }

    public void notifyUpdate(@NotNull InventoryContents var1);

    public <T extends PageEvent> void accept(@NotNull T var1);

    @NotNull
    public InventoryProvider provider();

    @NotNull
    public Page provider(@NotNull InventoryProvider var1);

    @NotNull
    public SmartInventory inventory();

    public long tick();

    @NotNull
    public Page tick(long var1);

    public long startDelay();

    @NotNull
    public Page startDelay(long var1);

    public boolean async();

    @NotNull
    public Page async(boolean var1);

    public boolean tickEnable();

    @NotNull
    public Page tickEnable(boolean var1);

    public int row();

    @NotNull
    public Page row(int var1);

    public int column();

    @NotNull
    public Page column(int var1);

    @NotNull
    public String title();

    @NotNull
    public Page title(@NotNull String var1);

    @NotNull
    public Optional<Page> parent();

    @NotNull
    public Page parent(@NotNull Page var1);

    @NotNull
    public Page id(@NotNull String var1);

    @NotNull
    public String id();

    public boolean canClose(@NotNull CloseEvent var1);

    @NotNull
    public Page canClose(@NotNull Predicate<CloseEvent> var1);

    @NotNull
    public Inventory open(@NotNull Player var1, int var2, @NotNull Map<String, Object> var3);

    public void close(@NotNull Player var1);
}

