/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.smartinventory.content;

import com.google.common.base.Preconditions;
import io.github.portlek.smartinventory.Icon;
import io.github.portlek.smartinventory.InventoryContents;
import io.github.portlek.smartinventory.SlotIterator;
import io.github.portlek.smartinventory.util.Pattern;
import io.github.portlek.smartinventory.util.SlotPos;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BasicSlotIterator
implements SlotIterator {
    @NotNull
    private final SlotIterator.Type type;
    @NotNull
    private final InventoryContents contents;
    private final int startRow;
    private final int startColumn;
    private final Set<SlotPos> blacklisted = new HashSet<SlotPos>();
    private boolean started;
    private boolean allowOverride = true;
    private int endRow;
    private int endColumn;
    private int row;
    private int column;
    private int patternRowOffset;
    private int patternColumnOffset;
    @Nullable
    private Pattern<Boolean> pattern;
    private int blacklistPatternRowOffset;
    private int blacklistPatternColumnOffset;
    @Nullable
    private Pattern<Boolean> blacklistPattern;

    public BasicSlotIterator(@NotNull InventoryContents contents, @NotNull SlotIterator.Type type) {
        this(contents, type, 0, 0);
    }

    public BasicSlotIterator(@NotNull InventoryContents contents, @NotNull SlotIterator.Type type, int startRow, int startColumn) {
        this.contents = contents;
        this.type = type;
        this.endRow = this.contents.page().row() - 1;
        this.endColumn = this.contents.page().column() - 1;
        this.startRow = startRow;
        this.row = startRow;
        this.startColumn = startColumn;
        this.column = startColumn;
    }

    @Override
    @NotNull
    public Optional<Icon> get() {
        return this.contents.get(this.row, this.column);
    }

    @Override
    @NotNull
    public SlotIterator set(@NotNull Icon icon) {
        if (this.canPlace()) {
            this.contents.set(this.row, this.column, icon);
        }
        return this;
    }

    @Override
    @NotNull
    public SlotIterator previous() {
        if (this.row == 0 && this.column == 0) {
            this.started = true;
            return this;
        }
        do {
            if (this.started) {
                if (this.type == SlotIterator.Type.HORIZONTAL) {
                    --this.column;
                    if (this.column != 0) continue;
                    this.column = this.contents.page().column() - 1;
                    --this.row;
                    continue;
                }
                if (this.type != SlotIterator.Type.VERTICAL) continue;
                --this.row;
                if (this.row != 0) continue;
                this.row = this.contents.page().row() - 1;
                --this.column;
                continue;
            }
            this.started = true;
        } while (!this.canPlace() && (this.row != 0 || this.column != 0));
        return this;
    }

    @Override
    @NotNull
    public SlotIterator next() {
        if (this.ended()) {
            this.started = true;
            return this;
        }
        do {
            if (this.started) {
                if (this.type == SlotIterator.Type.HORIZONTAL) {
                    ++this.column;
                    this.column %= this.contents.page().column();
                    if (this.column != 0) continue;
                    ++this.row;
                    continue;
                }
                if (this.type != SlotIterator.Type.VERTICAL) continue;
                ++this.row;
                this.row %= this.contents.page().row();
                if (this.row != 0) continue;
                ++this.column;
                continue;
            }
            this.started = true;
        } while (!this.canPlace() && !this.ended());
        return this;
    }

    @Override
    @NotNull
    public SlotIterator blacklist(int index) {
        int count = this.contents.page().column();
        this.blacklisted.add(SlotPos.of(index / count, index % count));
        return this;
    }

    @Override
    @NotNull
    public SlotIterator blacklist(int row, int column) {
        this.blacklisted.add(SlotPos.of(row, column));
        return this;
    }

    @Override
    public int row() {
        return this.row;
    }

    @Override
    @NotNull
    public SlotIterator row(int row) {
        this.row = row;
        return this;
    }

    @Override
    public int column() {
        return this.column;
    }

    @Override
    @NotNull
    public SlotIterator column(int column) {
        this.column = column;
        return this;
    }

    @Override
    @NotNull
    public SlotIterator reset() {
        this.started = false;
        return this.row(this.startRow).column(this.startColumn);
    }

    @Override
    public boolean started() {
        return this.started;
    }

    @Override
    public boolean ended() {
        return this.row == this.endRow && this.column == this.endColumn;
    }

    @Override
    @NotNull
    public SlotIterator endPosition(int row, int column) {
        if (row < 0) {
            row = this.contents.page().row() - 1;
        }
        if (column < 0) {
            column = this.contents.page().column() - 1;
        }
        Preconditions.checkArgument((row * column >= this.startRow * this.startColumn ? 1 : 0) != 0, (Object)"The end position needs to be after the start of the slot iterator");
        this.endRow = row;
        this.endColumn = column;
        return this;
    }

    @Override
    public boolean doesAllowOverride() {
        return this.allowOverride;
    }

    @Override
    @NotNull
    public SlotIterator allowOverride(boolean override) {
        this.allowOverride = override;
        return this;
    }

    @Override
    @NotNull
    public SlotIterator withPattern(@NotNull Pattern<Boolean> pattern, int rowOffset, int columnOffset) {
        this.patternRowOffset = rowOffset;
        this.patternColumnOffset = columnOffset;
        if (!pattern.getDefaultValue().isPresent()) {
            pattern.setDefault(false);
        }
        this.pattern = pattern;
        return this;
    }

    @Override
    @NotNull
    public SlotIterator blacklistPattern(@NotNull Pattern<Boolean> pattern, int rowOffset, int columnOffset) {
        this.blacklistPatternRowOffset = rowOffset;
        this.blacklistPatternColumnOffset = columnOffset;
        if (!pattern.getDefaultValue().isPresent()) {
            pattern.setDefault(false);
        }
        this.blacklistPattern = pattern;
        return this;
    }

    private boolean canPlace() {
        AtomicBoolean patternAllows = new AtomicBoolean(true);
        Optional.ofNullable(this.pattern).ifPresent(booleanPattern -> patternAllows.set(this.checkPattern((Pattern<Boolean>)booleanPattern, this.patternRowOffset, this.patternColumnOffset)));
        AtomicBoolean blacklistPatternAllows = new AtomicBoolean(true);
        Optional.ofNullable(this.blacklistPattern).ifPresent(booleanPattern -> blacklistPatternAllows.set(!this.checkPattern((Pattern<Boolean>)booleanPattern, this.blacklistPatternRowOffset, this.blacklistPatternColumnOffset)));
        return !this.blacklisted.contains(SlotPos.of(this.row, this.column)) && (this.allowOverride || !this.get().isPresent()) && patternAllows.get() && blacklistPatternAllows.get();
    }

    private boolean checkPattern(@NotNull Pattern<Boolean> pattern, int rowOffset, int columnOffset) {
        Optional<Boolean> object = pattern.getObject(this.row() - rowOffset, this.column() - columnOffset);
        if (pattern.isWrapAround()) {
            return object.orElse(false);
        }
        return this.row() >= rowOffset && this.column() >= columnOffset && this.row() < pattern.getRowCount() + rowOffset && this.column() < pattern.getColumnCount() + columnOffset && object.orElse(false) != false;
    }
}

