/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.smartinventory;

import io.github.portlek.smartinventory.InventoryContents;
import io.github.portlek.smartinventory.InventoryOpener;
import io.github.portlek.smartinventory.InventoryProvider;
import io.github.portlek.smartinventory.Page;
import io.github.portlek.smartinventory.event.PgTickEvent;
import io.github.portlek.smartinventory.listener.InventoryClickListener;
import io.github.portlek.smartinventory.listener.InventoryCloseListener;
import io.github.portlek.smartinventory.listener.InventoryDragListener;
import io.github.portlek.smartinventory.listener.InventoryOpenListener;
import io.github.portlek.smartinventory.listener.PlayerQuitListener;
import io.github.portlek.smartinventory.listener.PluginDisableListener;
import io.github.portlek.smartinventory.opener.ChestInventoryOpener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

public interface SmartInventory {
    public static final Function<SmartInventory, List<Listener>> LISTENERS = inventory -> Arrays.asList(new InventoryClickListener((SmartInventory)inventory), new InventoryOpenListener((SmartInventory)inventory), new InventoryCloseListener((SmartInventory)inventory), new PlayerQuitListener((SmartInventory)inventory), new PluginDisableListener((SmartInventory)inventory), new InventoryDragListener((SmartInventory)inventory));
    public static final List<InventoryOpener> DEFAULT_OPENERS = Collections.singletonList(new ChestInventoryOpener());

    default public void init() {
        LISTENERS.apply(this).forEach(listener -> Bukkit.getPluginManager().registerEvents(listener, this.getPlugin()));
    }

    @NotNull
    default public List<Player> getOpenedPlayers(@NotNull Page page) {
        ArrayList<Player> list = new ArrayList<Player>();
        this.getPages().forEach((player, playerInv) -> {
            if (page.equals(playerInv)) {
                list.add((Player)player);
            }
        });
        return list;
    }

    default public void notifyUpdate(@NotNull Player player) {
        this.getContents(player).ifPresent(InventoryContents::notifyUpdate);
    }

    default public <T extends InventoryProvider> void notifyUpdateForAll(@NotNull Class<T> provider) {
        this.getContents().values().stream().filter(inventoryContents -> provider.equals(inventoryContents.page().provider().getClass())).forEach(InventoryContents::notifyUpdate);
    }

    default public void notifyUpdateForAllById(@NotNull String id) {
        this.getPages().values().stream().filter(page -> page.id().equals(id)).forEach(Page::notifyUpdateForAll);
    }

    default public void stopTick(@NotNull Player player) {
        this.getTask(player).ifPresent(runnable -> {
            Bukkit.getScheduler().cancelTask(runnable.getTaskId());
            this.removeTask(player);
        });
    }

    default public void tick(final @NotNull Player player, final @NotNull Page page) {
        BukkitRunnable task = new BukkitRunnable(){

            public void run() {
                SmartInventory.this.getContents(player).ifPresent(inventoryContents -> {
                    page.accept(new PgTickEvent((InventoryContents)inventoryContents));
                    page.provider().tick((InventoryContents)inventoryContents);
                });
            }
        };
        if (page.async()) {
            task.runTaskTimerAsynchronously(this.getPlugin(), page.startDelay(), page.tick());
        } else {
            task.runTaskTimer(this.getPlugin(), page.startDelay(), page.tick());
        }
        this.setTask(player, task);
    }

    @NotNull
    default public Optional<InventoryOpener> findOpener(@NotNull InventoryType type) {
        return Stream.of(this.getOpeners(), DEFAULT_OPENERS).flatMap(Collection::stream).filter(opener -> opener.supports(type)).findAny();
    }

    default public void clearPages(@NotNull Predicate<InventoryContents> predicate) {
        new HashMap<Player, Page>(this.getPages()).keySet().forEach(player -> this.getContents((Player)player).filter(predicate).ifPresent(inventoryContents -> this.removePage((Player)player)));
    }

    default public void clearLastPages(@NotNull Predicate<Player> predicate) {
        new HashMap<Player, Page>(this.getLastPages()).forEach((player, page) -> {
            if (predicate.test((Player)player)) {
                this.removePage((Player)player);
            }
        });
    }

    @NotNull
    public Plugin getPlugin();

    @NotNull
    public Collection<InventoryOpener> getOpeners();

    @NotNull
    public Map<Player, Page> getLastPages();

    @NotNull
    public Map<Player, Page> getPages();

    @NotNull
    public Map<Player, InventoryContents> getContents();

    @NotNull
    public Map<Inventory, InventoryContents> getContentsByInventory();

    @NotNull
    public Optional<Page> getPage(@NotNull Player var1);

    @NotNull
    public Optional<Page> getLastPage(@NotNull Player var1);

    @NotNull
    public Optional<InventoryContents> getContents(@NotNull Player var1);

    @NotNull
    public Optional<InventoryContents> getContentsByInventory(@NotNull Inventory var1);

    @NotNull
    public Optional<BukkitRunnable> getTask(@NotNull Player var1);

    public void setPage(@NotNull Player var1, @NotNull Page var2);

    public void setContents(@NotNull Player var1, @NotNull InventoryContents var2);

    public void setContentsByInventory(@NotNull Inventory var1, @NotNull InventoryContents var2);

    public void setTask(@NotNull Player var1, @NotNull BukkitRunnable var2);

    public void removePage(@NotNull Player var1);

    public void removeLastPage(@NotNull Player var1);

    public void removeContent(@NotNull Player var1);

    public void removeContentByInventory(@NotNull Inventory var1);

    public void removeTask(@NotNull Player var1);

    public void clearPages();

    public void clearLastPages();

    public void clearContents();

    public void clearContentsByInventory();

    public void clearTask();

    public void registerOpeners(InventoryOpener ... var1);
}

