/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.smartinventory;

import com.google.common.base.Preconditions;
import io.github.portlek.smartinventory.Icon;
import io.github.portlek.smartinventory.Page;
import io.github.portlek.smartinventory.Pagination;
import io.github.portlek.smartinventory.SlotIterator;
import io.github.portlek.smartinventory.content.BasicSlotIterator;
import io.github.portlek.smartinventory.util.Pattern;
import io.github.portlek.smartinventory.util.SlotPos;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.ObjIntConsumer;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface InventoryContents {
    @NotNull
    default public SlotIterator newIterator(@NotNull SlotIterator.Type type, int startRow, int startColumn) {
        return new BasicSlotIterator(this, type, startRow, startColumn);
    }

    @NotNull
    default public SlotIterator newIterator(@NotNull String id, @NotNull SlotIterator.Type type, @NotNull SlotPos startPos) {
        return this.newIterator(id, type, startPos.getRow(), startPos.getColumn());
    }

    @NotNull
    default public SlotIterator newIterator(@NotNull SlotIterator.Type type, @NotNull SlotPos startPos) {
        return this.newIterator(type, startPos.getRow(), startPos.getColumn());
    }

    @NotNull
    default public List<SlotPos> slots() {
        ArrayList<SlotPos> position = new ArrayList<SlotPos>();
        Icon[][] all = this.all();
        for (int row = 0; row < all.length; ++row) {
            for (int column = 0; column < all[0].length; ++column) {
                position.add(SlotPos.of(row, column));
            }
        }
        return position;
    }

    @NotNull
    default public Optional<SlotPos> firstEmpty() {
        Icon[][] all = this.all();
        for (int row = 0; row < all.length; ++row) {
            for (int column = 0; column < all[0].length; ++column) {
                if (this.get(row, column).isPresent()) continue;
                return Optional.of(new SlotPos(row, column));
            }
        }
        return Optional.empty();
    }

    @NotNull
    default public Optional<Icon> get(int index) {
        int count = this.page().column();
        return this.get(index / count, index % count);
    }

    @NotNull
    default public Optional<Icon> get(int row, int column) {
        Icon[][] all = this.all();
        if (row < 0 || row >= all.length) {
            return Optional.empty();
        }
        if (column < 0 || column >= all[row].length) {
            return Optional.empty();
        }
        return Optional.ofNullable(all[row][column]);
    }

    @NotNull
    default public Optional<Icon> get(@NotNull SlotPos slotPos) {
        return this.get(slotPos.getRow(), slotPos.getColumn());
    }

    @NotNull
    default public InventoryContents applyRect(int fromRow, int fromColumn, int toRow, int toColumn, @NotNull ObjIntConsumer<Integer> apply) {
        for (int row = fromRow; row <= toRow; ++row) {
            for (int column = fromColumn; column <= toColumn; ++column) {
                apply.accept(row, column);
            }
        }
        return this;
    }

    @NotNull
    default public InventoryContents applyRect(int fromRow, int fromColumn, int toRow, int toColumn, @NotNull Consumer<Icon> apply) {
        return this.applyRect(fromRow, fromColumn, toRow, toColumn, (Integer row, int column) -> this.get((int)row, column).ifPresent(apply));
    }

    @NotNull
    default public InventoryContents set(int index, @Nullable Icon item) {
        int columnCount = this.page().column();
        return this.set(index / columnCount, index % columnCount, item);
    }

    @NotNull
    default public InventoryContents set(@NotNull SlotPos slotPos, @Nullable Icon item) {
        return this.set(slotPos.getRow(), slotPos.getColumn(), item);
    }

    @NotNull
    default public InventoryContents add(@NotNull Icon item) {
        Icon[][] all = this.all();
        for (int row = 0; row < all.length; ++row) {
            for (int column = 0; column < all[0].length; ++column) {
                if (all[row][column] != null) continue;
                this.set(row, column, item);
                return this;
            }
        }
        return this;
    }

    @NotNull
    default public Optional<SlotPos> findItem(@NotNull ItemStack item) {
        Icon[][] all = this.all();
        for (int row = 0; row < all.length; ++row) {
            for (int column = 0; column < all[0].length; ++column) {
                Icon icon = all[row][column];
                if (icon == null || !item.isSimilar(icon.calculateItem(this))) continue;
                return Optional.of(SlotPos.of(row, column));
            }
        }
        return Optional.empty();
    }

    @NotNull
    default public Optional<SlotPos> findItem(@NotNull Icon item) {
        return this.findItem(item.calculateItem(this));
    }

    default public void removeFirst(@NotNull ItemStack item) {
        this.findItem(item).ifPresent(slotPos -> this.set((SlotPos)slotPos, null));
    }

    default public void removeFirst(@NotNull Icon item) {
        this.removeFirst(item.getItem());
    }

    default public void removeAmount(@NotNull ItemStack item, int amount) {
        Icon[][] all = this.all();
        for (int row = 0; row < all.length; ++row) {
            for (int column = 0; column < all[row].length; ++column) {
                Icon icon = all[row][column];
                if (icon != null && !item.isSimilar(icon.getItem()) || icon == null) continue;
                ItemStack foundStack = icon.getItem();
                if (foundStack.getAmount() <= amount) {
                    this.set(row, column, null);
                    if ((amount -= foundStack.getAmount()) != 0) continue;
                    return;
                }
                if (foundStack.getAmount() <= amount) continue;
                ItemStack clonedStack = foundStack.clone();
                clonedStack.setAmount(clonedStack.getAmount() - amount);
                this.set(row, column, icon.item(clonedStack));
                return;
            }
        }
    }

    default public void removeAmount(@NotNull Icon item, int amount) {
        this.removeAmount(item.getItem(), amount);
    }

    default public void removeAll(@NotNull ItemStack item) {
        Icon[][] all = this.all();
        for (int row = 0; row < all.length; ++row) {
            for (int column = 0; column < all[row].length; ++column) {
                Icon icon = all[row][column];
                if (icon == null || !item.isSimilar(icon.getItem())) continue;
                this.set(row, column, null);
            }
        }
    }

    default public void removeAll(@NotNull Icon item) {
        this.removeAll(item.getItem());
    }

    @NotNull
    default public InventoryContents fill(@NotNull Icon item) {
        Icon[][] all = this.all();
        for (int row = 0; row < all.length; ++row) {
            for (int column = 0; column < all[row].length; ++column) {
                this.set(row, column, item);
            }
        }
        return this;
    }

    @NotNull
    default public InventoryContents fillEmpties(@NotNull Icon item) {
        Icon[][] all = this.all();
        for (int row = 0; row < all.length; ++row) {
            for (int column = 0; column < all[row].length; ++column) {
                Icon icon = all[row][column];
                if (icon != null && icon.getItem().getType() != Material.AIR) continue;
                this.set(row, column, item);
            }
        }
        return this;
    }

    @NotNull
    default public InventoryContents fillRow(int row, @NotNull Icon item) {
        Icon[][] all = this.all();
        if (row < 0 || row >= all.length) {
            return this;
        }
        for (int column = 0; column < all[row].length; ++column) {
            this.set(row, column, item);
        }
        return this;
    }

    @NotNull
    default public InventoryContents fillColumn(int column, @NotNull Icon item) {
        Icon[][] all = this.all();
        if (column < 0 || column >= all[0].length) {
            return this;
        }
        for (int row = 0; row < all.length; ++row) {
            this.set(row, column, item);
        }
        return this;
    }

    @NotNull
    default public InventoryContents fillBorders(@NotNull Icon item) {
        this.fillRect(0, 0, this.page().row() - 1, this.page().column() - 1, item);
        return this;
    }

    @NotNull
    default public InventoryContents fillRect(int fromIndex, int toIndex, @NotNull Icon item) {
        int count = this.page().column();
        return this.fillRect(fromIndex / count, fromIndex % count, toIndex / count, toIndex % count, item);
    }

    @NotNull
    default public InventoryContents fillRect(int fromRow, int fromColumn, int toRow, int toColumn, @NotNull Icon item) {
        return this.applyRect(fromRow, fromColumn, toRow, toColumn, (Integer row, int column) -> {
            if (row == fromRow || row == toRow || column == fromColumn || column == toColumn) {
                this.set((int)row, column, item);
            }
        });
    }

    @NotNull
    default public InventoryContents fillRect(@NotNull SlotPos fromPos, @NotNull SlotPos toPos, @NotNull Icon item) {
        return this.fillRect(fromPos.getRow(), fromPos.getColumn(), toPos.getRow(), toPos.getColumn(), item);
    }

    @NotNull
    default public InventoryContents fillSquare(int fromIndex, int toIndex, @NotNull Icon item) {
        int count = this.page().column();
        return this.fillSquare(fromIndex / count, fromIndex % count, toIndex / count, toIndex % count, item);
    }

    @NotNull
    default public InventoryContents fillSquare(int fromRow, int fromColumn, int toRow, int toColumn, @NotNull Icon item) {
        Preconditions.checkArgument((fromRow < toRow ? 1 : 0) != 0, (Object)"The start row needs to be lower than the end row");
        Preconditions.checkArgument((fromColumn < toColumn ? 1 : 0) != 0, (Object)"The start column needs to be lower than the end column");
        for (int row = fromRow; row <= toRow; ++row) {
            for (int column = fromColumn; column <= toColumn; ++column) {
                this.set(row, column, item);
            }
        }
        return this;
    }

    @NotNull
    default public InventoryContents fillSquare(@NotNull SlotPos fromPos, @NotNull SlotPos toPos, @NotNull Icon item) {
        return this.fillSquare(fromPos.getRow(), fromPos.getColumn(), toPos.getRow(), toPos.getColumn(), item);
    }

    @NotNull
    default public InventoryContents fillPattern(@NotNull Pattern<Icon> pattern) {
        return this.fillPattern(pattern, 0, 0);
    }

    @NotNull
    default public InventoryContents fillPattern(@NotNull Pattern<Icon> pattern, int startIndex) {
        int count = this.page().column();
        return this.fillPattern(pattern, startIndex / count, startIndex % count);
    }

    @NotNull
    default public InventoryContents fillPattern(@NotNull Pattern<Icon> pattern, int startRow, int startColumn) {
        for (int row = 0; row < pattern.getRowCount(); ++row) {
            for (int column = 0; column < pattern.getColumnCount(); ++column) {
                int finalRow = startRow + row;
                int finalColumn = startColumn + column;
                pattern.getObject(row, column).ifPresent(icon -> this.set(finalRow, finalColumn, (Icon)icon));
            }
        }
        return this;
    }

    @NotNull
    default public InventoryContents fillPattern(@NotNull Pattern<Icon> pattern, @NotNull SlotPos startPos) {
        return this.fillPattern(pattern, startPos.getRow(), startPos.getColumn());
    }

    @NotNull
    default public InventoryContents fillPatternRepeating(@NotNull Pattern<Icon> pattern) {
        return this.fillPatternRepeating(pattern, 0, 0, -1, -1);
    }

    @NotNull
    default public InventoryContents fillPatternRepeating(@NotNull Pattern<Icon> pattern, int startIndex, int endIndex) {
        boolean maxSize;
        int columnCount = this.page().column();
        boolean bl = maxSize = endIndex < 0;
        if (maxSize) {
            return this.fillPatternRepeating(pattern, startIndex / columnCount, startIndex % columnCount, -1, -1);
        }
        return this.fillPatternRepeating(pattern, startIndex / columnCount, startIndex % columnCount, endIndex / columnCount, endIndex % columnCount);
    }

    @NotNull
    default public InventoryContents fillPatternRepeating(@NotNull Pattern<Icon> pattern, int startRow, int startColumn, int endRow, int endColumn) {
        Preconditions.checkArgument((boolean)pattern.isWrapAround(), (Object)"To fill in a repeating pattern wrapAround needs to be enabled for the pattern to work!");
        if (endRow < 0) {
            endRow = this.page().row();
        }
        if (endColumn < 0) {
            endColumn = this.page().column();
        }
        Preconditions.checkArgument((startRow < endRow ? 1 : 0) != 0, (Object)"The start row needs to be lower than the end row");
        Preconditions.checkArgument((startColumn < endColumn ? 1 : 0) != 0, (Object)"The start column needs to be lower than the end column");
        int rowDelta = endRow - startRow;
        int columnDelta = endColumn - startColumn;
        for (int row = 0; row <= rowDelta; ++row) {
            for (int column = 0; column <= columnDelta; ++column) {
                int finalRow = startRow + row;
                int finalColumn = startColumn + column;
                pattern.getObject(row, column).ifPresent(icon -> this.set(finalRow, finalColumn, (Icon)icon));
            }
        }
        return this;
    }

    @NotNull
    default public InventoryContents fillPatternRepeating(@NotNull Pattern<Icon> pattern, @NotNull SlotPos startPos, @NotNull SlotPos endPos) {
        return this.fillPatternRepeating(pattern, startPos.getRow(), startPos.getColumn(), endPos.getRow(), endPos.getColumn());
    }

    @NotNull
    default public Inventory getBottomInventory() {
        return this.player().getOpenInventory().getBottomInventory();
    }

    @NotNull
    default public Inventory getTopInventory() {
        return this.player().getOpenInventory().getTopInventory();
    }

    default public void reopen() {
        this.page().open(this.player());
    }

    default public void openNext() {
        this.page().open(this.player(), this.pagination().next().getPage());
    }

    default public void openPrevious() {
        this.page().open(this.player(), this.pagination().previous().getPage());
    }

    default public void notifyUpdate() {
        this.page().notifyUpdate(this);
    }

    default public void notifyUpdateForAll() {
        this.page().notifyUpdateForAll();
    }

    default public void notifyUpdateForAllById() {
        this.page().notifyUpdateForAllById();
    }

    default public InventoryContents setEditable(@NotNull SlotPos slot) {
        return this.setEditable(slot, true);
    }

    @NotNull
    public Page page();

    @NotNull
    public Pagination pagination();

    @NotNull
    public Icon[][] all();

    @NotNull
    public Player player();

    @NotNull
    public Optional<SlotIterator> iterator(@NotNull String var1);

    @Nullable
    public <T> T getProperty(@NotNull String var1);

    @NotNull
    public <T> T getPropertyOrDefault(@NotNull String var1, @NotNull T var2);

    @NotNull
    public SlotIterator newIterator(@NotNull String var1, @NotNull SlotIterator.Type var2, int var3, int var4);

    @NotNull
    public InventoryContents set(int var1, int var2, @Nullable Icon var3);

    @NotNull
    public InventoryContents setProperty(@NotNull String var1, @NotNull Object var2);

    public InventoryContents setEditable(@NotNull SlotPos var1, boolean var2);

    public boolean isEditable(@NotNull SlotPos var1);
}

