/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.smartinventory.handle;

import io.github.portlek.smartinventory.Handle;
import io.github.portlek.smartinventory.Type;
import io.github.portlek.smartinventory.event.abs.SmartEvent;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public final class BasicHandle<T extends SmartEvent>
extends Type<T>
implements Handle<T> {
    @NotNull
    private final Consumer<T> consumer;
    @NotNull
    private final List<Predicate<T>> requirements;

    public BasicHandle(@NotNull Class<T> clazz, @NotNull Consumer<T> consumer, @NotNull List<Predicate<T>> requirements) {
        super(clazz);
        this.consumer = consumer;
        this.requirements = requirements;
    }

    @Override
    public void accept(@NotNull T t) {
        if (this.requirements.stream().allMatch(req -> req.test(t))) {
            this.consumer.accept(t);
        }
    }
}

