/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.smartinventory.icon;

import io.github.portlek.smartinventory.Handle;
import io.github.portlek.smartinventory.Icon;
import io.github.portlek.smartinventory.InventoryContents;
import io.github.portlek.smartinventory.event.abs.IconEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class BasicIcon
implements Icon {
    private final Collection<Handle<? extends IconEvent>> handles = new ArrayList<Handle<? extends IconEvent>>();
    @NotNull
    private ItemStack item;
    @NotNull
    private Predicate<InventoryContents> canSee = contents -> true;
    @NotNull
    private Predicate<InventoryContents> canUse = contents -> true;
    @NotNull
    private ItemStack fallback = new ItemStack(Material.AIR);

    public BasicIcon(@NotNull ItemStack item) {
        this.item = item;
    }

    @Override
    @NotNull
    public ItemStack getItem() {
        return this.item;
    }

    @Override
    @NotNull
    public ItemStack calculateItem(@NotNull InventoryContents contents) {
        ItemStack calculated = this.canSee.test(contents) ? this.getItem() : this.fallback;
        return calculated;
    }

    @Override
    public <T extends IconEvent> void accept(@NotNull T event) {
        InventoryContents contents = event.contents();
        if (this.canSee.test(contents) && this.canUse.test(contents)) {
            this.handles.stream().filter(target -> true).map(target -> target).forEach(target -> target.accept(event));
        }
    }

    @Override
    @NotNull
    public <T extends IconEvent> Icon handle(@NotNull Handle<T> handle) {
        this.handles.add(handle);
        return this;
    }

    @Override
    @NotNull
    public Icon handles(@NotNull Collection<Handle<? extends IconEvent>> handles) {
        this.handles.addAll(handles);
        return this;
    }

    @Override
    @NotNull
    public Icon canSee(@NotNull Predicate<InventoryContents> predicate) {
        this.canSee = predicate;
        return this;
    }

    @Override
    @NotNull
    public Icon canUse(@NotNull Predicate<InventoryContents> predicate) {
        this.canUse = predicate;
        return this;
    }

    @Override
    @NotNull
    public Icon fallback(@NotNull ItemStack fallback) {
        this.fallback = fallback;
        return this;
    }

    @Override
    @NotNull
    public Icon item(@NotNull ItemStack item) {
        this.item = item;
        return this;
    }
}

