/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.smartinventory.opener;

import io.github.portlek.smartinventory.InventoryContents;
import io.github.portlek.smartinventory.InventoryOpener;
import io.github.portlek.smartinventory.Page;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.NotNull;

public final class ChestInventoryOpener
implements InventoryOpener {
    @Override
    public Inventory open(@NotNull Page page, @NotNull Player player) {
        if (page.column() != 9) {
            throw new IllegalArgumentException(String.format("The column count for the chest inventory must be 9, found: %s.", page.column()));
        }
        if (page.row() < 1 && page.row() > 6) {
            throw new IllegalArgumentException(String.format("The row count for the chest inventory must be between 1 and 6, found: %s", page.row()));
        }
        Inventory handle = Bukkit.createInventory((InventoryHolder)player, (int)(page.row() * page.column()), (String)page.title());
        page.inventory().getContents(player).ifPresent(contents -> {
            this.fill(handle, (InventoryContents)contents);
            player.openInventory(handle);
        });
        return handle;
    }

    @Override
    public boolean supports(@NotNull InventoryType type) {
        return type == InventoryType.CHEST || type == InventoryType.ENDER_CHEST;
    }
}

