/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.smartinventory.manager;

import io.github.portlek.smartinventory.InventoryContents;
import io.github.portlek.smartinventory.InventoryOpener;
import io.github.portlek.smartinventory.InventoryProvided;
import io.github.portlek.smartinventory.Page;
import io.github.portlek.smartinventory.SmartInventory;
import io.github.portlek.smartinventory.event.PgTickEvent;
import io.github.portlek.smartinventory.listener.InventoryClickListener;
import io.github.portlek.smartinventory.listener.InventoryCloseListener;
import io.github.portlek.smartinventory.listener.InventoryDragListener;
import io.github.portlek.smartinventory.listener.InventoryOpenListener;
import io.github.portlek.smartinventory.listener.PlayerQuitListener;
import io.github.portlek.smartinventory.listener.PluginDisableListener;
import io.github.portlek.smartinventory.opener.ChestInventoryOpener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

public final class BasicSmartInventory
implements SmartInventory {
    private final Map<Player, Page> lastpages = new HashMap<Player, Page>();
    private final Map<Player, Page> pages = new HashMap<Player, Page>();
    private final Map<Player, InventoryContents> contents = new HashMap<Player, InventoryContents>();
    private final Map<Inventory, InventoryContents> contentsByInventory = new HashMap<Inventory, InventoryContents>();
    private final Map<Player, BukkitRunnable> tasks = new HashMap<Player, BukkitRunnable>();
    private final List<InventoryOpener> defaulters = Collections.singletonList(new ChestInventoryOpener());
    private final Collection<InventoryOpener> openers = new ArrayList<InventoryOpener>();
    @NotNull
    private final Plugin plugin;

    @Override
    @NotNull
    public void init() {
        Arrays.asList(new InventoryClickListener(this), new InventoryOpenListener(this), new InventoryCloseListener(this), new PlayerQuitListener(this), new PluginDisableListener(this), new InventoryDragListener(this)).forEach(listener -> Bukkit.getPluginManager().registerEvents(listener, this.plugin));
    }

    @Override
    @NotNull
    public Optional<InventoryOpener> findOpener(@NotNull InventoryType type) {
        return Stream.of(this.openers, this.defaulters).flatMap(Collection::stream).filter(opener -> opener.supports(type)).findAny();
    }

    @Override
    public void registerOpeners(InventoryOpener ... openers) {
        this.openers.addAll(Arrays.asList(openers));
    }

    @Override
    @NotNull
    public List<Player> getOpenedPlayers(@NotNull Page inv) {
        ArrayList<Player> list = new ArrayList<Player>();
        this.pages.forEach((player, playerInv) -> {
            if (inv.equals(playerInv)) {
                list.add((Player)player);
            }
        });
        return list;
    }

    @Override
    @NotNull
    public Optional<Page> getPage(@NotNull Player player) {
        return Optional.ofNullable(this.pages.get(player));
    }

    @Override
    @NotNull
    public Optional<Page> getLastPage(@NotNull Player player) {
        return Optional.ofNullable(this.lastpages.get(player));
    }

    @Override
    public void notifyUpdate(@NotNull Player player) {
        this.getContents(player).ifPresent(InventoryContents::notifyUpdate);
    }

    @Override
    public <T extends InventoryProvided> void notifyUpdateForAll(@NotNull Class<T> provider) {
        this.contents.values().stream().filter(contents -> provider.equals(contents.page().provider().getClass())).forEach(InventoryContents::notifyUpdate);
    }

    @Override
    public <T extends InventoryProvided> void notifyUpdateForAllById(@NotNull String id) {
        this.pages.values().stream().filter(page -> page.id().equals(id)).forEach(Page::notifyUpdateForAll);
    }

    @Override
    @NotNull
    public Optional<InventoryContents> getContents(@NotNull Player player) {
        return Optional.ofNullable(this.contents.get(player));
    }

    @Override
    @NotNull
    public Optional<InventoryContents> getContentsByInventory(@NotNull Inventory inventory) {
        return Optional.ofNullable(this.contentsByInventory.get(inventory));
    }

    @Override
    @NotNull
    public Map<Player, Page> getPages() {
        return Collections.unmodifiableMap(this.pages);
    }

    @Override
    @NotNull
    public Map<Player, InventoryContents> getContents() {
        return Collections.unmodifiableMap(this.contents);
    }

    @Override
    @NotNull
    public Map<Inventory, InventoryContents> getContentsByInventory() {
        return Collections.unmodifiableMap(this.contentsByInventory);
    }

    @Override
    public void removePage(@NotNull Player player) {
        this.pages.remove(player);
    }

    @Override
    public void removeLastPage(@NotNull Player player) {
        this.lastpages.remove(player);
    }

    @Override
    public void removeContent(@NotNull Player player) {
        this.contents.remove(player);
    }

    @Override
    public void removeContentByInventory(@NotNull Inventory inventory) {
        this.contentsByInventory.remove(inventory);
    }

    @Override
    public void clearPages(@NotNull Predicate<InventoryContents> predicate) {
        new HashMap<Player, Page>(this.pages).keySet().forEach(player -> Optional.ofNullable(this.contents.get(player)).filter(predicate).ifPresent(contents -> this.pages.remove(player)));
    }

    @Override
    public void clearPages() {
        this.pages.clear();
    }

    @Override
    public void clearLastPages(@NotNull Predicate<Player> predicate) {
        HashMap<Player, Page> temp = new HashMap<Player, Page>(this.lastpages);
        temp.forEach((player, page) -> {
            if (predicate.test((Player)player)) {
                this.pages.remove(player);
            }
        });
    }

    @Override
    public void clearLastPages() {
        this.lastpages.clear();
    }

    @Override
    public void clearContents() {
        this.contents.clear();
    }

    @Override
    public void clearContentsByInventory() {
        this.contentsByInventory.clear();
    }

    @Override
    public void stopTick(Player player) {
        Optional.ofNullable(this.tasks.get(player)).ifPresent(runnable -> {
            Bukkit.getScheduler().cancelTask(runnable.getTaskId());
            this.tasks.remove(player);
        });
    }

    @Override
    public void setPage(@NotNull Player player, @NotNull Page page) {
        this.pages.put(player, page);
        this.lastpages.put(player, page);
    }

    @Override
    public void setContents(@NotNull Player player, @NotNull InventoryContents contest) {
        this.contents.put(player, contest);
    }

    @Override
    public void setContentsByInventory(@NotNull Inventory inventory, @NotNull InventoryContents contest) {
        this.contentsByInventory.put(inventory, contest);
    }

    @Override
    public void tick(final @NotNull Player player, final @NotNull Page page) {
        BukkitRunnable task = new BukkitRunnable(){

            public void run() {
                Optional.ofNullable(BasicSmartInventory.this.contents.get(player)).ifPresent(contents -> {
                    page.accept(new PgTickEvent((InventoryContents)contents));
                    page.provider().tick((InventoryContents)contents);
                });
            }
        };
        if (page.async()) {
            task.runTaskTimerAsynchronously(this.plugin, page.startDelay(), page.tick());
        } else {
            task.runTaskTimer(this.plugin, page.startDelay(), page.tick());
        }
        this.tasks.put(player, task);
    }

    public BasicSmartInventory(@NotNull Plugin plugin) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        this.plugin = plugin;
    }

    @Override
    @NotNull
    public Plugin getPlugin() {
        return this.plugin;
    }
}

