/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.smartinventory.listener;

import io.github.portlek.smartinventory.Icon;
import io.github.portlek.smartinventory.InventoryContents;
import io.github.portlek.smartinventory.Page;
import io.github.portlek.smartinventory.SmartInventory;
import io.github.portlek.smartinventory.event.IcClickEvent;
import io.github.portlek.smartinventory.event.PgBottomClickEvent;
import io.github.portlek.smartinventory.event.PgClickEvent;
import io.github.portlek.smartinventory.event.PgOutsideClickEvent;
import io.github.portlek.smartinventory.util.SlotPos;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class InventoryClickListener
implements Listener {
    @NotNull
    private final SmartInventory inventory;

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        int column;
        Player player = (Player)event.getWhoClicked();
        Optional<Page> optional = this.inventory.getPage(player);
        if (!optional.isPresent()) {
            return;
        }
        Page page = optional.get();
        Optional<InventoryContents> contentsoptional = this.inventory.getContents(player);
        if (!contentsoptional.isPresent()) {
            return;
        }
        InventoryContents contents = contentsoptional.get();
        if (event.getAction() == InventoryAction.COLLECT_TO_CURSOR) {
            event.setCancelled(true);
            return;
        }
        Inventory clicked = event.getClickedInventory();
        if (clicked == null) {
            page.accept(new PgOutsideClickEvent(this.inventory.getPlugin(), event, contents));
            return;
        }
        if (clicked.equals(player.getOpenInventory().getBottomInventory())) {
            page.accept(new PgBottomClickEvent(this.inventory.getPlugin(), event, contents));
            return;
        }
        ItemStack current = event.getCurrentItem();
        if (current == null || current.getType() == Material.AIR) {
            page.accept(new PgClickEvent(this.inventory.getPlugin(), event, contents));
            return;
        }
        int row = event.getSlot() / 9;
        if (!page.checkBounds(row, column = event.getSlot() % 9)) {
            return;
        }
        SlotPos slot = SlotPos.of(row, column);
        if (!contents.isEditable(slot)) {
            event.setCancelled(true);
        }
        contents.get(slot).ifPresent(item -> item.accept(new IcClickEvent(this.inventory.getPlugin(), event, contents, (Icon)item)));
        if (!contents.isEditable(slot)) {
            player.updateInventory();
        }
    }

    public InventoryClickListener(@NotNull SmartInventory inventory) {
        if (inventory == null) {
            throw new NullPointerException("inventory is marked non-null but is null");
        }
        this.inventory = inventory;
    }
}

