/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.smartinventory.event;

import io.github.portlek.smartinventory.Icon;
import io.github.portlek.smartinventory.InventoryContents;
import io.github.portlek.smartinventory.event.abs.DragEvent;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.event.inventory.DragType;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class IcDragEvent
implements DragEvent {
    @NotNull
    private final Plugin plugin;
    @NotNull
    private final InventoryDragEvent event;
    @NotNull
    private final InventoryContents contents;
    @NotNull
    private final Icon icon;

    @Override
    @NotNull
    public DragType drag() {
        return this.event.getType();
    }

    @Override
    @NotNull
    public Map<Integer, ItemStack> added() {
        return this.event.getNewItems();
    }

    @Override
    @NotNull
    public Set<Integer> slots() {
        return this.event.getInventorySlots();
    }

    @Override
    @NotNull
    public Optional<ItemStack> newcursor() {
        return Optional.ofNullable(this.event.getCursor());
    }

    @Override
    @NotNull
    public Icon icon() {
        return this.icon;
    }

    @Override
    @NotNull
    public InventoryContents contents() {
        return this.contents;
    }

    @Override
    public void cancel() {
        this.event.setCancelled(true);
    }

    @Override
    public void close() {
        Bukkit.getScheduler().runTask(this.plugin, () -> this.contents.page().close(this.contents.player()));
    }

    public IcDragEvent(@NotNull Plugin plugin, @NotNull InventoryDragEvent event, @NotNull InventoryContents contents, @NotNull Icon icon) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (contents == null) {
            throw new NullPointerException("contents is marked non-null but is null");
        }
        if (icon == null) {
            throw new NullPointerException("icon is marked non-null but is null");
        }
        this.plugin = plugin;
        this.event = event;
        this.contents = contents;
        this.icon = icon;
    }
}

