/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.smartinventory;

import io.github.portlek.smartinventory.InventoryContents;
import io.github.portlek.smartinventory.InventoryProvided;
import io.github.portlek.smartinventory.SmartInventory;
import io.github.portlek.smartinventory.Target;
import io.github.portlek.smartinventory.event.abs.BottomClickEvent;
import io.github.portlek.smartinventory.event.abs.CloseEvent;
import io.github.portlek.smartinventory.event.abs.InitEvent;
import io.github.portlek.smartinventory.event.abs.OpenEvent;
import io.github.portlek.smartinventory.event.abs.OutsideClickEvent;
import io.github.portlek.smartinventory.event.abs.PageClickEvent;
import io.github.portlek.smartinventory.event.abs.PageEvent;
import io.github.portlek.smartinventory.event.abs.TickEvent;
import io.github.portlek.smartinventory.event.abs.UpdateEvent;
import io.github.portlek.smartinventory.page.BasicPage;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;

public interface Page {
    public static Page build(@NotNull SmartInventory inventory, @NotNull InventoryProvided provided) {
        return new BasicPage(inventory, provided);
    }

    public static Page build(@NotNull SmartInventory inventory) {
        return new BasicPage(inventory);
    }

    public void notifyUpdate(@NotNull InventoryContents var1);

    public void notifyUpdateForAll();

    public void notifyUpdateForAllById();

    public <T extends PageEvent> void accept(@NotNull T var1);

    @NotNull
    public InventoryProvided provider();

    @NotNull
    public Page provider(@NotNull InventoryProvided var1);

    @NotNull
    public SmartInventory inventory();

    public long tick();

    @NotNull
    public Page tick(long var1);

    public long startDelay();

    @NotNull
    public Page startDelay(long var1);

    public boolean async();

    @NotNull
    public Page async(boolean var1);

    public boolean tickEnable();

    @NotNull
    public Page tickEnable(boolean var1);

    public int row();

    @NotNull
    public Page row(int var1);

    public int column();

    @NotNull
    public Page column(int var1);

    @NotNull
    public String title();

    @NotNull
    public Page title(@NotNull String var1);

    @NotNull
    public Page parent(@NotNull Page var1);

    @NotNull
    public Optional<Page> parent();

    @NotNull
    public Page id(@NotNull String var1);

    @NotNull
    public String id();

    @NotNull
    default public Page whenClose(@NotNull Consumer<CloseEvent> consumer) {
        return this.whenClose(consumer, new Predicate[0]);
    }

    @NotNull
    default public Page whenClose(@NotNull Consumer<CloseEvent> consumer, Predicate<CloseEvent> ... requirements) {
        return this.target(CloseEvent.class, consumer, requirements);
    }

    @NotNull
    default public Page whenOpen(@NotNull Consumer<OpenEvent> consumer) {
        return this.whenOpen(consumer, new Predicate[0]);
    }

    @NotNull
    default public Page whenOpen(@NotNull Consumer<OpenEvent> consumer, Predicate<OpenEvent> ... requirements) {
        return this.target(OpenEvent.class, consumer, requirements);
    }

    @NotNull
    default public Page whenInit(@NotNull Consumer<InitEvent> consumer) {
        return this.whenInit(consumer, new Predicate[0]);
    }

    @NotNull
    default public Page whenInit(@NotNull Consumer<InitEvent> consumer, Predicate<InitEvent> ... requirements) {
        return this.target(InitEvent.class, consumer, requirements);
    }

    @NotNull
    default public Page whenUpdate(@NotNull Consumer<UpdateEvent> consumer) {
        return this.whenUpdate(consumer, new Predicate[0]);
    }

    @NotNull
    default public Page whenUpdate(@NotNull Consumer<UpdateEvent> consumer, Predicate<UpdateEvent> ... requirements) {
        return this.target(UpdateEvent.class, consumer, requirements);
    }

    @NotNull
    default public Page whenTick(@NotNull Consumer<TickEvent> consumer) {
        return this.whenTick(consumer, new Predicate[0]);
    }

    @NotNull
    default public Page whenTick(@NotNull Consumer<TickEvent> consumer, Predicate<TickEvent> ... requirements) {
        return this.target(TickEvent.class, consumer, requirements);
    }

    @NotNull
    default public Page whenBottomClick(@NotNull Consumer<BottomClickEvent> consumer) {
        return this.whenBottomClick(consumer, new Predicate[0]);
    }

    @NotNull
    default public Page whenBottomClick(@NotNull Consumer<BottomClickEvent> consumer, Predicate<BottomClickEvent> ... requirements) {
        return this.target(BottomClickEvent.class, consumer, requirements);
    }

    @NotNull
    default public Page whenOutsideClick(@NotNull Consumer<OutsideClickEvent> consumer) {
        return this.whenOutsideClick(consumer, new Predicate[0]);
    }

    @NotNull
    default public Page whenOutsideClick(@NotNull Consumer<OutsideClickEvent> consumer, Predicate<OutsideClickEvent> ... requirements) {
        return this.target(OutsideClickEvent.class, consumer, requirements);
    }

    @NotNull
    default public Page whenEmptyClick(@NotNull Consumer<PageClickEvent> consumer) {
        return this.whenEmptyClick(consumer, new Predicate[0]);
    }

    @NotNull
    default public Page whenEmptyClick(@NotNull Consumer<PageClickEvent> consumer, Predicate<PageClickEvent> ... requirements) {
        return this.target(PageClickEvent.class, consumer, requirements);
    }

    @NotNull
    default public <T extends PageEvent> Page target(@NotNull Class<T> clazz, @NotNull Consumer<T> consumer, Predicate<T> ... requirements) {
        return this.target(Target.from(clazz, consumer, requirements));
    }

    @NotNull
    public <T extends PageEvent> Page target(@NotNull Target<T> var1);

    @NotNull
    default public Page canClose(boolean canClose) {
        return this.canClose((CloseEvent event) -> canClose);
    }

    @NotNull
    public Page canClose(@NotNull Predicate<CloseEvent> var1);

    public boolean canClose(@NotNull CloseEvent var1);

    public boolean checkBounds(int var1, int var2);

    @NotNull
    default public void open(@NotNull Player player) {
        this.open(player, 0);
    }

    default public void open(@NotNull Player player, int page) {
        this.open(player, page, Collections.emptyMap());
    }

    default public void open(@NotNull Player player, @NotNull Map<String, Object> properties) {
        this.open(player, 0, properties);
    }

    @NotNull
    public Inventory open(@NotNull Player var1, int var2, @NotNull Map<String, Object> var3);

    public void close(@NotNull Player var1);
}

