/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.smartinventory.content;

import com.google.common.base.Preconditions;
import io.github.portlek.smartinventory.Icon;
import io.github.portlek.smartinventory.InventoryContents;
import io.github.portlek.smartinventory.Page;
import io.github.portlek.smartinventory.Pagination;
import io.github.portlek.smartinventory.SlotIterator;
import io.github.portlek.smartinventory.content.BasicPagination;
import io.github.portlek.smartinventory.content.BasicSlotIterator;
import io.github.portlek.smartinventory.util.Pattern;
import io.github.portlek.smartinventory.util.SlotPos;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BasicInventoryContents
implements InventoryContents {
    private final Pagination pagination = new BasicPagination();
    private final Map<String, SlotIterator> iterators = new HashMap<String, SlotIterator>();
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final Set<SlotPos> editableSlots = new HashSet<SlotPos>();
    @NotNull
    private final Page page;
    @NotNull
    private final Player player;
    @NotNull
    private final Icon[][] contents;

    public BasicInventoryContents(@NotNull Page page, @NotNull Player player) {
        this(page, player, new Icon[page.row()][page.column()]);
    }

    @Override
    @NotNull
    public Page page() {
        return this.page;
    }

    @Override
    @NotNull
    public Pagination pagination() {
        return this.pagination;
    }

    @Override
    @NotNull
    public Optional<SlotIterator> iterator(@NotNull String id) {
        return Optional.ofNullable(this.iterators.get(id));
    }

    @Override
    @NotNull
    public SlotIterator newIterator(@NotNull String id, @NotNull SlotIterator.Type type, int startRow, int startColumn) {
        BasicSlotIterator iterator = new BasicSlotIterator(this, type, startRow, startColumn);
        this.iterators.put(id, iterator);
        return iterator;
    }

    @Override
    @NotNull
    public SlotIterator newIterator(@NotNull SlotIterator.Type type, int startRow, int startColumn) {
        return new BasicSlotIterator(this, type, startRow, startColumn);
    }

    @Override
    @NotNull
    public SlotIterator newIterator(@NotNull String id, @NotNull SlotIterator.Type type, @NotNull SlotPos startPos) {
        return this.newIterator(id, type, startPos.getRow(), startPos.getColumn());
    }

    @Override
    @NotNull
    public SlotIterator newIterator(@NotNull SlotIterator.Type type, @NotNull SlotPos startPos) {
        return this.newIterator(type, startPos.getRow(), startPos.getColumn());
    }

    @Override
    @NotNull
    public Icon[][] all() {
        return (Icon[][])this.contents.clone();
    }

    @Override
    @NotNull
    public List<SlotPos> slots() {
        ArrayList<SlotPos> position = new ArrayList<SlotPos>();
        for (int row = 0; row < this.contents.length; ++row) {
            for (int column = 0; column < this.contents[0].length; ++column) {
                position.add(SlotPos.of(row, column));
            }
        }
        return position;
    }

    @Override
    @NotNull
    public Optional<SlotPos> firstEmpty() {
        for (int row = 0; row < this.contents.length; ++row) {
            for (int column = 0; column < this.contents[0].length; ++column) {
                if (this.get(row, column).isPresent()) continue;
                return Optional.of(new SlotPos(row, column));
            }
        }
        return Optional.empty();
    }

    @Override
    @NotNull
    public Optional<Icon> get(int index) {
        int count = this.page.column();
        return this.get(index / count, index % count);
    }

    @Override
    @NotNull
    public Optional<Icon> get(int row, int column) {
        if (row < 0 || row >= this.contents.length) {
            return Optional.empty();
        }
        if (column < 0 || column >= this.contents[row].length) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.contents[row][column]);
    }

    @Override
    @NotNull
    public Optional<Icon> get(@NotNull SlotPos pos) {
        return this.get(pos.getRow(), pos.getColumn());
    }

    @Override
    @NotNull
    public InventoryContents set(int index, @NotNull Icon item) {
        int columnCount = this.page.column();
        return this.set(index / columnCount, index % columnCount, item);
    }

    @Override
    @NotNull
    public InventoryContents set(int row, int column, @Nullable Icon item) {
        if (row < 0 || row >= this.contents.length) {
            return this;
        }
        if (column < 0 || column >= this.contents[row].length) {
            return this;
        }
        this.contents[row][column] = item;
        if (item == null) {
            this.update(row, column, null);
        } else {
            this.update(row, column, item.calculateItem(this));
        }
        return this;
    }

    @Override
    @NotNull
    public InventoryContents set(@NotNull SlotPos slotPos, @Nullable Icon item) {
        return this.set(slotPos.getRow(), slotPos.getColumn(), item);
    }

    @Override
    @NotNull
    public InventoryContents add(@NotNull Icon item) {
        for (int row = 0; row < this.contents.length; ++row) {
            for (int column = 0; column < this.contents[0].length; ++column) {
                if (this.contents[row][column] != null) continue;
                this.set(row, column, item);
                return this;
            }
        }
        return this;
    }

    @Override
    @NotNull
    public Optional<SlotPos> findItem(@NotNull ItemStack itemStack) {
        for (int row = 0; row < this.contents.length; ++row) {
            for (int column = 0; column < this.contents[0].length; ++column) {
                Icon item = this.contents[row][column];
                if (item == null || !itemStack.isSimilar(item.calculateItem(this))) continue;
                return Optional.of(SlotPos.of(row, column));
            }
        }
        return Optional.empty();
    }

    @Override
    @NotNull
    public Optional<SlotPos> findItem(@NotNull Icon item) {
        return this.findItem(item.calculateItem(this));
    }

    @Override
    public void removeFirst(@NotNull ItemStack item) {
        this.findItem(item).ifPresent(slotPos -> this.set((SlotPos)slotPos, null));
    }

    @Override
    public void removeFirst(@NotNull Icon item) {
        this.removeFirst(item.calculateItem());
    }

    @Override
    public void removeAmount(@NotNull ItemStack item, int amount) {
        for (int row = 0; row < this.contents.length; ++row) {
            for (int column = 0; column < this.contents[row].length; ++column) {
                Icon icon = this.contents[row][column];
                if (!item.isSimilar(icon.calculateItem())) continue;
                ItemStack foundStack = icon.calculateItem();
                if (foundStack.getAmount() <= amount) {
                    this.set(row, column, null);
                    if ((amount -= foundStack.getAmount()) != 0) continue;
                    return;
                }
                if (foundStack.getAmount() <= amount) continue;
                ItemStack clonedStack = foundStack.clone();
                clonedStack.setAmount(clonedStack.getAmount() - amount);
                Icon clonedIcon = icon.clone(clonedStack);
                this.set(row, column, clonedIcon);
                return;
            }
        }
    }

    @Override
    public void removeAmount(@NotNull Icon item, int amount) {
        this.removeAmount(item.calculateItem(), amount);
    }

    @Override
    public void removeAll(@NotNull ItemStack item) {
        for (int row = 0; row < this.contents.length; ++row) {
            for (int column = 0; column < this.contents[row].length; ++column) {
                if (this.contents[row][column] == null || !item.isSimilar(this.contents[row][column].calculateItem())) continue;
                this.set(row, column, null);
            }
        }
    }

    @Override
    public void removeAll(@NotNull Icon item) {
        this.removeAll(item.calculateItem());
    }

    @Override
    @NotNull
    public InventoryContents fill(@NotNull Icon item) {
        for (int row = 0; row < this.contents.length; ++row) {
            for (int column = 0; column < this.contents[row].length; ++column) {
                this.set(row, column, item);
            }
        }
        return this;
    }

    @Override
    @NotNull
    public InventoryContents fillEmpties(@NotNull Icon item) {
        for (int row = 0; row < this.contents.length; ++row) {
            for (int column = 0; column < this.contents[row].length; ++column) {
                if (this.contents[row][column] != null && this.contents[row][column].calculateItem().getType() != Material.AIR) continue;
                this.set(row, column, item);
            }
        }
        return this;
    }

    @Override
    @NotNull
    public InventoryContents fillRow(int row, @NotNull Icon item) {
        if (row < 0 || row >= this.contents.length) {
            return this;
        }
        for (int column = 0; column < this.contents[row].length; ++column) {
            this.set(row, column, item);
        }
        return this;
    }

    @Override
    @NotNull
    public InventoryContents fillColumn(int column, @NotNull Icon item) {
        if (column < 0 || column >= this.contents[0].length) {
            return this;
        }
        for (int row = 0; row < this.contents.length; ++row) {
            this.set(row, column, item);
        }
        return this;
    }

    @Override
    @NotNull
    public InventoryContents fillBorders(@NotNull Icon item) {
        this.fillRect(0, 0, this.page.row() - 1, this.page.column() - 1, item);
        return this;
    }

    @Override
    @NotNull
    public InventoryContents fillRect(int fromIndex, int toIndex, @NotNull Icon item) {
        int count = this.page.column();
        return this.fillRect(fromIndex / count, fromIndex % count, toIndex / count, toIndex % count, item);
    }

    @Override
    @NotNull
    public InventoryContents fillRect(int fromRow, int fromColumn, int toRow, int toColumn, @NotNull Icon item) {
        return this.applyRect(fromRow, fromColumn, toRow, toColumn, (Integer row, Integer column) -> {
            if (row == fromRow || row == toRow || column == fromColumn || column == toColumn) {
                this.set((int)row, (int)column, item);
            }
        });
    }

    @Override
    @NotNull
    public InventoryContents fillRect(@NotNull SlotPos fromPos, @NotNull SlotPos toPos, @NotNull Icon item) {
        return this.fillRect(fromPos.getRow(), fromPos.getColumn(), toPos.getRow(), toPos.getColumn(), item);
    }

    @Override
    @NotNull
    public InventoryContents fillSquare(int fromIndex, int toIndex, @NotNull Icon item) {
        int count = this.page.column();
        return this.fillSquare(fromIndex / count, fromIndex % count, toIndex / count, toIndex % count, item);
    }

    @Override
    @NotNull
    public InventoryContents fillSquare(int fromRow, int fromColumn, int toRow, int toColumn, @NotNull Icon item) {
        Preconditions.checkArgument((fromRow < toRow ? 1 : 0) != 0, (Object)"The start row needs to be lower than the end row");
        Preconditions.checkArgument((fromColumn < toColumn ? 1 : 0) != 0, (Object)"The start column needs to be lower than the end column");
        for (int row = fromRow; row <= toRow; ++row) {
            for (int column = fromColumn; column <= toColumn; ++column) {
                this.set(row, column, item);
            }
        }
        return this;
    }

    @Override
    @NotNull
    public InventoryContents fillSquare(@NotNull SlotPos fromPos, @NotNull SlotPos toPos, @NotNull Icon item) {
        return this.fillSquare(fromPos.getRow(), fromPos.getColumn(), toPos.getRow(), toPos.getColumn(), item);
    }

    @Override
    @NotNull
    public InventoryContents fillPattern(@NotNull Pattern<Icon> pattern) {
        return this.fillPattern(pattern, 0, 0);
    }

    @Override
    @NotNull
    public InventoryContents fillPattern(@NotNull Pattern<Icon> pattern, int startIndex) {
        int count = this.page.column();
        return this.fillPattern(pattern, startIndex / count, startIndex % count);
    }

    @Override
    @NotNull
    public InventoryContents fillPattern(@NotNull Pattern<Icon> pattern, int startRow, int startColumn) {
        for (int row = 0; row < pattern.getRowCount(); ++row) {
            for (int column = 0; column < pattern.getColumnCount(); ++column) {
                int finalRow = startRow + row;
                int finalColumn = startColumn + column;
                pattern.getObject(row, column).ifPresent(icon -> this.set(finalRow, finalColumn, (Icon)icon));
            }
        }
        return this;
    }

    @Override
    @NotNull
    public InventoryContents fillPattern(@NotNull Pattern<Icon> pattern, @NotNull SlotPos startPos) {
        return this.fillPattern(pattern, startPos.getRow(), startPos.getColumn());
    }

    @Override
    @NotNull
    public InventoryContents fillPatternRepeating(@NotNull Pattern<Icon> pattern) {
        return this.fillPatternRepeating(pattern, 0, 0, -1, -1);
    }

    @Override
    @NotNull
    public InventoryContents fillPatternRepeating(@NotNull Pattern<Icon> pattern, int startIndex, int endIndex) {
        boolean maxSize;
        int columnCount = this.page.column();
        boolean bl = maxSize = endIndex < 0;
        if (maxSize) {
            return this.fillPatternRepeating(pattern, startIndex / columnCount, startIndex % columnCount, -1, -1);
        }
        return this.fillPatternRepeating(pattern, startIndex / columnCount, startIndex % columnCount, endIndex / columnCount, endIndex % columnCount);
    }

    @Override
    @NotNull
    public InventoryContents fillPatternRepeating(@NotNull Pattern<Icon> pattern, int startRow, int startColumn, int endRow, int endColumn) {
        Preconditions.checkArgument((boolean)pattern.isWrapAround(), (Object)"To fill in a repeating pattern wrapAround needs to be enabled for the pattern to work!");
        if (endRow < 0) {
            endRow = this.page.row();
        }
        if (endColumn < 0) {
            endColumn = this.page.column();
        }
        Preconditions.checkArgument((startRow < endRow ? 1 : 0) != 0, (Object)"The start row needs to be lower than the end row");
        Preconditions.checkArgument((startColumn < endColumn ? 1 : 0) != 0, (Object)"The start column needs to be lower than the end column");
        int rowDelta = endRow - startRow;
        int columnDelta = endColumn - startColumn;
        for (int row = 0; row <= rowDelta; ++row) {
            for (int column = 0; column <= columnDelta; ++column) {
                int finalRow = startRow + row;
                int finalColumn = startColumn + column;
                pattern.getObject(row, column).ifPresent(icon -> this.set(finalRow, finalColumn, (Icon)icon));
            }
        }
        return this;
    }

    @Override
    @NotNull
    public InventoryContents fillPatternRepeating(@NotNull Pattern<Icon> pattern, @NotNull SlotPos startPos, @NotNull SlotPos endPos) {
        return this.fillPatternRepeating(pattern, startPos.getRow(), startPos.getColumn(), endPos.getRow(), endPos.getColumn());
    }

    @Override
    @NotNull
    public InventoryContents applyRect(int fromRow, int fromColumn, int toRow, int toColumn, @NotNull BiConsumer<Integer, Integer> apply) {
        for (int row = fromRow; row <= toRow; ++row) {
            for (int column = fromColumn; column <= toColumn; ++column) {
                apply.accept(row, column);
            }
        }
        return this;
    }

    @Override
    @NotNull
    public InventoryContents applyRect(int fromRow, int fromColumn, int toRow, int toColumn, @NotNull Consumer<Icon> apply) {
        return this.applyRect(fromRow, fromColumn, toRow, toColumn, (Integer row, Integer column) -> this.get((int)row, (int)column).ifPresent(apply));
    }

    @Override
    @Nullable
    public <T> T getProperty(@NotNull String name) {
        return (T)this.properties.get(name);
    }

    @Override
    @NotNull
    public <T> T getPropertyOrDefault(@NotNull String name, @NotNull T def) {
        return (T)this.properties.getOrDefault(name, def);
    }

    @Override
    @NotNull
    public InventoryContents setProperty(@NotNull String name, @NotNull Object value) {
        this.properties.put(name, value);
        return this;
    }

    @Override
    @NotNull
    public InventoryContents setEditable(@NotNull SlotPos slot, boolean editable) {
        if (editable) {
            this.editableSlots.add(slot);
        } else {
            this.editableSlots.remove(slot);
        }
        return this;
    }

    @Override
    public boolean isEditable(@NotNull SlotPos slot) {
        return this.editableSlots.contains(slot);
    }

    @Override
    @NotNull
    public Player player() {
        return this.player;
    }

    @Override
    @NotNull
    public Inventory getBottomInventory() {
        return this.player.getOpenInventory().getBottomInventory();
    }

    @Override
    @NotNull
    public Inventory getTopInventory() {
        return this.player.getOpenInventory().getTopInventory();
    }

    @Override
    public void notifyUpdate() {
        this.page.notifyUpdate(this);
    }

    @Override
    public void notifyUpdateForAll() {
        this.page.notifyUpdateForAll();
    }

    private void update(int row, int column, @Nullable ItemStack item) {
        if (this.page.inventory().getOpenedPlayers(this.page).contains(this.player)) {
            Inventory inv = this.getTopInventory();
            inv.setItem(this.page.column() * row + column, item);
        }
    }

    public BasicInventoryContents(@NotNull Page page, @NotNull Player player, @NotNull Icon[][] contents) {
        if (page == null) {
            throw new NullPointerException("page is marked non-null but is null");
        }
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (contents == null) {
            throw new NullPointerException("contents is marked non-null but is null");
        }
        this.page = page;
        this.player = player;
        this.contents = contents;
    }
}

