/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.smartinventory.target;

import io.github.portlek.smartinventory.Target;
import io.github.portlek.smartinventory.event.abs.SmartEvent;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public final class BasicTarget<T extends SmartEvent>
implements Target<T> {
    @NotNull
    private final Class<T> clazz;
    @NotNull
    private final Consumer<T> consumer;
    @NotNull
    private final List<Predicate<T>> requirements;

    @SafeVarargs
    public BasicTarget(@NotNull Class<T> clazz, @NotNull Consumer<T> consumer, Predicate<T> ... requirements) {
        this(clazz, consumer, Arrays.asList(requirements));
    }

    @Override
    public void accept(@NotNull T event) {
        if (this.requirements.stream().allMatch(req -> req.test(event))) {
            this.consumer.accept(event);
        }
    }

    @Override
    @NotNull
    public Class<T> getType() {
        return this.clazz;
    }

    public BasicTarget(@NotNull Class<T> clazz, @NotNull Consumer<T> consumer, @NotNull List<Predicate<T>> requirements) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (requirements == null) {
            throw new NullPointerException("requirements is marked non-null but is null");
        }
        this.clazz = clazz;
        this.consumer = consumer;
        this.requirements = requirements;
    }
}

