/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.smartinventory.page;

import io.github.portlek.observer.Source;
import io.github.portlek.observer.source.BasicSource;
import io.github.portlek.smartinventory.InventoryContents;
import io.github.portlek.smartinventory.InventoryOpener;
import io.github.portlek.smartinventory.InventoryProvided;
import io.github.portlek.smartinventory.Page;
import io.github.portlek.smartinventory.SmartInventory;
import io.github.portlek.smartinventory.Target;
import io.github.portlek.smartinventory.content.BasicInventoryContents;
import io.github.portlek.smartinventory.event.PgCloseEvent;
import io.github.portlek.smartinventory.event.PgInitEvent;
import io.github.portlek.smartinventory.event.PgUpdateEvent;
import io.github.portlek.smartinventory.event.abs.CloseEvent;
import io.github.portlek.smartinventory.event.abs.PageEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BasicPage
implements Page {
    private final Source<InventoryContents> source = new BasicSource<InventoryContents>();
    private final Collection<Target<? extends PageEvent>> targets = new ArrayList<Target<? extends PageEvent>>();
    @NotNull
    private final SmartInventory inventory;
    @NotNull
    private final InventoryType type = InventoryType.CHEST;
    @NotNull
    private InventoryProvided provided;
    @NotNull
    private String title = "Smart Inventory";
    private int row = 1;
    private int column = 9;
    private long tick = 1L;
    private long startDelay = 1L;
    private boolean async = false;
    private boolean tickEnable = true;
    @NotNull
    private Predicate<CloseEvent> canClose = event -> true;
    @Nullable
    private Page parent;

    public BasicPage(@NotNull SmartInventory inventory, @NotNull InventoryProvided provided) {
        this.inventory = inventory;
        this.provided = provided;
    }

    public BasicPage(@NotNull SmartInventory inventory) {
        this(inventory, InventoryProvided.EMPTY);
    }

    @Override
    public void notifyUpdate(@NotNull InventoryContents contents) {
        this.accept(new PgUpdateEvent(contents));
        this.source.notifyTargets(contents);
    }

    @Override
    public <T extends PageEvent> void accept(@NotNull T event) {
        this.targets.stream().filter(target -> target.getType().isAssignableFrom(event.getClass())).map(target -> target).forEach(target -> target.accept(event));
    }

    @Override
    @NotNull
    public InventoryProvided provider() {
        return this.provided;
    }

    @Override
    @NotNull
    public Page provider(@NotNull InventoryProvided provided) {
        this.provided = provided;
        return this;
    }

    @Override
    @NotNull
    public SmartInventory inventory() {
        return this.inventory;
    }

    @Override
    public long tick() {
        return this.tick;
    }

    @Override
    @NotNull
    public Page tick(long tick) {
        this.tick = tick;
        return this;
    }

    @Override
    public long startDelay() {
        return this.startDelay;
    }

    @Override
    @NotNull
    public Page startDelay(long startDelay) {
        this.startDelay = startDelay;
        return this;
    }

    @Override
    public boolean async() {
        return this.async;
    }

    @Override
    @NotNull
    public Page async(boolean async) {
        this.async = async;
        return this;
    }

    @Override
    public boolean tickEnable() {
        return this.tickEnable;
    }

    @Override
    @NotNull
    public Page tickEnable(boolean tickEnable) {
        this.tickEnable = tickEnable;
        return this;
    }

    @Override
    public int row() {
        return this.row;
    }

    @Override
    @NotNull
    public Page row(int row) {
        this.row = row;
        return this;
    }

    @Override
    public int column() {
        return this.column;
    }

    @Override
    @NotNull
    public Page column(int column) {
        this.column = column;
        return this;
    }

    @Override
    @NotNull
    public String title() {
        return this.title;
    }

    @Override
    @NotNull
    public Page title(@NotNull String title) {
        this.title = title;
        return this;
    }

    @Override
    @NotNull
    public Page parent(@NotNull Page parent) {
        this.parent = parent;
        return this;
    }

    @Override
    @NotNull
    public Optional<Page> parent() {
        return Optional.ofNullable(this.parent);
    }

    @Override
    @NotNull
    public <T extends PageEvent> Page target(@NotNull Target<T> target) {
        this.targets.add(target);
        return this;
    }

    @Override
    @NotNull
    public Page canClose(@NotNull Predicate<CloseEvent> predicate) {
        this.canClose = predicate;
        return this;
    }

    @Override
    public boolean canClose(@NotNull CloseEvent predicate) {
        return this.canClose.test(predicate);
    }

    @Override
    public boolean checkBounds(int row, int column) {
        if (row >= 0) {
            return column >= 0;
        }
        if (row < this.row) {
            return column < this.column;
        }
        return false;
    }

    @Override
    public void open(@NotNull Player player, int page, @NotNull Map<String, Object> properties) {
        this.close(player);
        InventoryOpener opener = this.inventory.findOpener(this.type).orElseThrow(() -> new IllegalStateException("No opener found for the inventory type " + this.type.name()));
        this.source.subscribe(this.provided);
        BasicInventoryContents contents = new BasicInventoryContents(this, player);
        contents.pagination().page(page);
        properties.forEach(contents::setProperty);
        this.inventory.setContents(player, contents);
        this.accept(new PgInitEvent(contents));
        this.provider().init(contents);
        opener.open(this, player);
        this.inventory.setPage(player, this);
        if (this.tickEnable()) {
            this.inventory.tick(player, this);
        }
    }

    @Override
    public void close(@NotNull Player player) {
        this.inventory.getContents(player).map(PgCloseEvent::new).ifPresent(this::accept);
        this.inventory.stopTick(player);
        this.inventory.removePage(player);
        this.inventory.removeContent(player);
        this.source.unsubscribe(this.provided);
        player.closeInventory();
    }
}

