/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.smartinventory.event;

import io.github.portlek.smartinventory.InventoryContents;
import io.github.portlek.smartinventory.event.abs.OutsideClickEvent;
import org.bukkit.Bukkit;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class PgOutsideClickEvent
implements OutsideClickEvent {
    @NotNull
    private final Plugin plugin;
    @NotNull
    private final InventoryClickEvent event;
    @NotNull
    private final InventoryContents contents;

    @Override
    @NotNull
    public InventoryContents contents() {
        return this.contents;
    }

    @Override
    public void cancel() {
        this.event.setCancelled(true);
    }

    @Override
    public void close() {
        Bukkit.getScheduler().runTaskLater(this.plugin, () -> this.contents.page().close(this.contents.player()), 1L);
    }

    public PgOutsideClickEvent(@NotNull Plugin plugin, @NotNull InventoryClickEvent event, @NotNull InventoryContents contents) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (contents == null) {
            throw new NullPointerException("contents is marked non-null but is null");
        }
        this.plugin = plugin;
        this.event = event;
        this.contents = contents;
    }
}

