/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.smartinventory;

import io.github.portlek.smartinventory.InventoryContents;
import io.github.portlek.smartinventory.Target;
import io.github.portlek.smartinventory.event.abs.ClickEvent;
import io.github.portlek.smartinventory.event.abs.DragEvent;
import io.github.portlek.smartinventory.event.abs.IconEvent;
import io.github.portlek.smartinventory.event.abs.SmartEvent;
import io.github.portlek.smartinventory.icon.BasicIcon;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public interface Icon {
    public static final Icon EMPTY = Icon.empty();

    @NotNull
    public static Icon from(@NotNull ItemStack item) {
        return new BasicIcon(item);
    }

    @SafeVarargs
    @NotNull
    public static Icon click(@NotNull ItemStack item, @NotNull Consumer<ClickEvent> consumer, Predicate<ClickEvent> ... requirements) {
        return Icon.from(item).whenClick(consumer, requirements);
    }

    @SafeVarargs
    @NotNull
    public static Icon drag(@NotNull ItemStack item, @NotNull Consumer<DragEvent> consumer, Predicate<DragEvent> ... requirements) {
        return Icon.from(item).whenDrag(consumer, requirements);
    }

    @NotNull
    public static Icon cancel(@NotNull ItemStack item) {
        return Icon.from(item).whenInteract(SmartEvent::cancel);
    }

    @NotNull
    public static Icon empty() {
        return Icon.from(new ItemStack(Material.AIR));
    }

    @NotNull
    public ItemStack calculateItem();

    @NotNull
    public ItemStack calculateItem(@NotNull InventoryContents var1);

    public <T extends IconEvent> void accept(@NotNull T var1);

    @NotNull
    default public Icon whenInteract(@NotNull Consumer<IconEvent> consumer) {
        return this.whenInteract(consumer, new Predicate[0]);
    }

    @NotNull
    default public Icon whenInteract(@NotNull Consumer<IconEvent> consumer, Predicate<IconEvent> ... requirements) {
        return this.target(IconEvent.class, consumer, requirements);
    }

    @NotNull
    default public Icon whenDrag(@NotNull Consumer<DragEvent> consumer) {
        return this.whenDrag(consumer, new Predicate[0]);
    }

    @NotNull
    default public Icon whenDrag(@NotNull Consumer<DragEvent> consumer, Predicate<DragEvent> ... requirements) {
        return this.target(DragEvent.class, consumer, requirements);
    }

    @NotNull
    default public Icon whenClick(@NotNull Consumer<ClickEvent> consumer) {
        return this.whenClick(consumer, new Predicate[0]);
    }

    @NotNull
    default public Icon whenClick(@NotNull Consumer<ClickEvent> consumer, Predicate<ClickEvent> ... requirements) {
        return this.target(ClickEvent.class, consumer, requirements);
    }

    @NotNull
    default public <T extends IconEvent> Icon target(@NotNull Class<T> clazz, @NotNull Consumer<T> consumer, Predicate<T> ... requirements) {
        return this.target(Target.from(clazz, consumer, requirements));
    }

    @NotNull
    public <T extends IconEvent> Icon target(@NotNull Target<T> var1);

    @NotNull
    public Icon targets(@NotNull Collection<Target<? extends IconEvent>> var1);

    @NotNull
    public Icon canSee(@NotNull Predicate<InventoryContents> var1);

    @NotNull
    public Icon canUse(@NotNull Predicate<InventoryContents> var1);

    @NotNull
    public Icon fallback(@NotNull ItemStack var1);

    @NotNull
    public Icon clone(@NotNull ItemStack var1);
}

