/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.smartinventory.util;

import com.google.common.base.Preconditions;
import io.github.portlek.smartinventory.util.SlotPos;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class Pattern<T> {
    private final Map<Character, T> mapping = new HashMap<Character, T>();
    private final String[] lines;
    private final boolean wrapAround;
    private T defaultValue;

    public Pattern(String ... lines) {
        this(false, lines);
    }

    public Pattern(boolean wrapAround, String ... lines) {
        Preconditions.checkArgument((lines.length > 0 ? 1 : 0) != 0, (Object)"The given pattern lines must not be empty.");
        int count = lines[0].length();
        this.lines = new String[lines.length];
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            Preconditions.checkNotNull((Object)line, (String)"The given pattern line %s cannot be null.", (int)i);
            Preconditions.checkArgument((line.length() == count ? 1 : 0) != 0, (String)"The given pattern line %s does not match the first line character count.", (int)i);
            this.lines[i] = lines[i];
        }
        this.wrapAround = wrapAround;
    }

    public Pattern<T> attach(char character, T object) {
        this.mapping.put(Character.valueOf(character), object);
        return this;
    }

    public T getObject(int index) {
        int count = this.getColumnCount();
        return this.getObject(index / count, index % count);
    }

    public int getColumnCount() {
        return this.lines[0].length();
    }

    public T getObject(int row, int column) {
        int rowclone = row;
        int columnclone = column;
        if (this.wrapAround) {
            if ((rowclone %= this.getRowCount()) < 0) {
                rowclone += this.getRowCount();
            }
            if ((columnclone %= this.getColumnCount()) < 0) {
                columnclone += this.getColumnCount();
            }
        } else {
            Preconditions.checkElementIndex((int)rowclone, (int)this.lines.length, (String)"The row must be between 0 and the row count");
            Preconditions.checkElementIndex((int)columnclone, (int)this.lines[0].length(), (String)"The column must be between 0 and the column size");
        }
        return this.mapping.getOrDefault(Character.valueOf(this.lines[rowclone].charAt(columnclone)), this.defaultValue);
    }

    public int getRowCount() {
        return this.lines.length;
    }

    public T getObject(SlotPos slot) {
        return this.getObject(slot.getRow(), slot.getColumn());
    }

    public Optional<SlotPos> findKey(char character) {
        for (int row = 0; row < this.getRowCount(); ++row) {
            for (int column = 0; column < this.getColumnCount(); ++column) {
                if (this.lines[row].charAt(column) != character) continue;
                return Optional.of(SlotPos.of(row, column));
            }
        }
        return Optional.empty();
    }

    public List<SlotPos> findAllKeys(char character) {
        ArrayList<SlotPos> positions = new ArrayList<SlotPos>();
        for (int row = 0; row < this.getRowCount(); ++row) {
            for (int column = 0; column < this.getColumnCount(); ++column) {
                if (this.lines[row].charAt(column) != character) continue;
                positions.add(SlotPos.of(row, column));
            }
        }
        return positions;
    }

    public T getDefault() {
        return this.defaultValue;
    }

    public Pattern<T> setDefault(T defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public boolean isWrapAround() {
        return this.wrapAround;
    }
}

