/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.smartinventory.target;

import io.github.portlek.smartinventory.Requirement;
import io.github.portlek.smartinventory.Target;
import io.github.portlek.smartinventory.event.abs.SmartEvent;
import java.util.Arrays;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public final class BasicTarget<T extends SmartEvent>
implements Target<T> {
    @NotNull
    private final Class<T> clazz;
    @NotNull
    private final Consumer<T> consumer;
    @NotNull
    private final Requirement<T>[] requirements;

    @SafeVarargs
    public BasicTarget(@NotNull Class<T> clazz, @NotNull Consumer<T> consumer, Requirement<T> ... requirements) {
        this.clazz = clazz;
        this.consumer = consumer;
        this.requirements = (Requirement[])requirements.clone();
    }

    @Override
    public void accept(@NotNull T event) {
        boolean control = Arrays.stream(this.requirements).allMatch(req -> req.test(event));
        if (control) {
            this.consumer.accept(event);
        }
    }

    @Override
    @NotNull
    public Class<T> getType() {
        return this.clazz;
    }
}

