/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.smartinventory.page;

import io.github.portlek.smartinventory.InventoryContents;
import io.github.portlek.smartinventory.InventoryProvided;
import io.github.portlek.smartinventory.Page;
import io.github.portlek.smartinventory.SmartInventory;
import io.github.portlek.smartinventory.Target;
import io.github.portlek.smartinventory.content.BasicInventoryContents;
import io.github.portlek.smartinventory.event.PgCloseEvent;
import io.github.portlek.smartinventory.event.abs.CloseEvent;
import io.github.portlek.smartinventory.event.abs.OpenEvent;
import io.github.portlek.smartinventory.event.abs.PageEvent;
import io.github.portlek.smartinventory.observer.Source;
import io.github.portlek.smartinventory.observer.source.BasicSource;
import io.github.portlek.smartinventory.opener.InventoryOpener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;

public final class BasicPage
implements Page {
    private final Source<InventoryContents> source = new BasicSource<InventoryContents>();
    private final Collection<Target<? extends PageEvent>> targets = new ArrayList<Target<? extends PageEvent>>();
    private final Predicate<PageEvent> control = event -> event instanceof CloseEvent && this.canClose((CloseEvent)event) || event instanceof OpenEvent && this.canOpen((OpenEvent)event);
    @NotNull
    private final SmartInventory inventory;
    @NotNull
    private final InventoryProvided provided;
    @NotNull
    private final InventoryType type = InventoryType.CHEST;
    @NotNull
    private String title = "Smart Inventory";
    private int row = 1;
    private int column = 9;
    private long tick = 1L;
    private boolean async = false;
    @NotNull
    private Predicate<OpenEvent> canopen = event -> true;
    @NotNull
    private Predicate<CloseEvent> canclose = event -> true;

    public BasicPage(@NotNull SmartInventory inventory, @NotNull InventoryProvided provided) {
        this.inventory = inventory;
        this.provided = provided;
        this.source.subscribe(provided);
    }

    @Override
    public void notifyUpdate(@NotNull InventoryContents contents) {
        this.source.notifyTargets(contents);
    }

    @Override
    public <T extends PageEvent> void accept(@NotNull T event) {
        this.targets.stream().filter(target -> target.getType().isAssignableFrom(event.getClass())).map(target -> target).forEach(target -> target.accept(event));
    }

    @Override
    @NotNull
    public InventoryProvided provider() {
        return this.provided;
    }

    @Override
    @NotNull
    public SmartInventory inventory() {
        return this.inventory;
    }

    @Override
    public long tick() {
        return this.tick;
    }

    @Override
    @NotNull
    public Page tick(long tick) {
        this.tick = tick;
        return this;
    }

    @Override
    public boolean async() {
        return this.async;
    }

    @Override
    @NotNull
    public Page async(boolean async) {
        this.async = async;
        return this;
    }

    @Override
    public int row() {
        return this.row;
    }

    @Override
    @NotNull
    public Page row(int row) {
        this.row = row;
        return this;
    }

    @Override
    public int column() {
        return this.column;
    }

    @Override
    @NotNull
    public Page column(int column) {
        this.column = column;
        return this;
    }

    @Override
    @NotNull
    public String title() {
        return this.title;
    }

    @Override
    @NotNull
    public Page title(@NotNull String title) {
        this.title = title;
        return this;
    }

    @Override
    @NotNull
    public <T extends PageEvent> Page target(@NotNull Target<T> target) {
        this.targets.add(target);
        return this;
    }

    @Override
    @NotNull
    public Page canOpen(@NotNull Predicate<OpenEvent> predicate) {
        this.canopen = predicate;
        return this;
    }

    @Override
    @NotNull
    public Page canClose(@NotNull Predicate<CloseEvent> predicate) {
        this.canclose = predicate;
        return this;
    }

    @Override
    public boolean canOpen(@NotNull OpenEvent predicate) {
        return this.canopen.test(predicate);
    }

    @Override
    public boolean canClose(@NotNull CloseEvent predicate) {
        return this.canclose.test(predicate);
    }

    @Override
    public boolean checkBounds(int row, int column) {
        if (row < 0 || column < 0) {
            return false;
        }
        return row < this.row && column < this.column;
    }

    @Override
    @NotNull
    public Inventory open(@NotNull Player player, int page, @NotNull Map<String, Object> properties) {
        this.close(player);
        BasicInventoryContents contents = new BasicInventoryContents(this, player);
        contents.pagination().page(page);
        properties.forEach(contents::setProperty);
        this.inventory.setContents(player, contents);
        this.provider().init(contents);
        InventoryOpener opener = this.inventory.findOpener(this.type).orElseThrow(() -> new IllegalStateException("No opener found for the inventory type " + this.type.name()));
        Inventory handle = opener.open(this, player);
        this.inventory.setPage(player, this);
        this.inventory.tick(player, this);
        return handle;
    }

    @Override
    public void close(@NotNull Player player) {
        this.inventory.getContents(player).map(PgCloseEvent::new).ifPresent(this::accept);
        this.inventory.removePage(player);
        this.inventory.removeContent(player);
        this.inventory.stopTick(player);
        player.closeInventory();
    }
}

