/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.smartinventory.opener;

import io.github.portlek.smartinventory.Icon;
import io.github.portlek.smartinventory.InventoryContents;
import io.github.portlek.smartinventory.Page;
import io.github.portlek.smartinventory.util.SlotPos;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;

public interface InventoryOpener {
    @NotNull
    public Inventory open(@NotNull Page var1, @NotNull Player var2);

    public boolean supports(@NotNull InventoryType var1);

    default public void fill(@NotNull Inventory handle, @NotNull InventoryContents contents) {
        Icon[][] items = contents.all();
        for (int row = 0; row < items.length; ++row) {
            for (int column = 0; column < items[row].length; ++column) {
                if (items[row][column] == null) continue;
                handle.setItem(9 * row + column, items[row][column].calculateItem(contents));
            }
        }
    }

    default public SlotPos defaultSize(@NotNull InventoryType type) {
        switch (type) {
            case CHEST: 
            case ENDER_CHEST: {
                return SlotPos.of(3, 9);
            }
            case DISPENSER: 
            case DROPPER: {
                return SlotPos.of(3, 3);
            }
        }
        return SlotPos.of(1, type.getDefaultSize());
    }
}

