/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.smartinventory.manager;

import io.github.portlek.smartinventory.InventoryContents;
import io.github.portlek.smartinventory.Page;
import io.github.portlek.smartinventory.SmartInventory;
import io.github.portlek.smartinventory.listener.InventoryClickListener;
import io.github.portlek.smartinventory.listener.InventoryCloseListener;
import io.github.portlek.smartinventory.listener.InventoryDragListener;
import io.github.portlek.smartinventory.listener.InventoryOpenListener;
import io.github.portlek.smartinventory.listener.PlayerQuitListener;
import io.github.portlek.smartinventory.listener.PluginDisableListener;
import io.github.portlek.smartinventory.opener.ChestInventoryOpener;
import io.github.portlek.smartinventory.opener.InventoryOpener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

public final class BasicSmartInventory
implements SmartInventory {
    @NotNull
    private final Plugin plugin;
    private final Map<Player, Page> pages = new HashMap<Player, Page>();
    private final Map<Player, InventoryContents> contents = new HashMap<Player, InventoryContents>();
    private final Map<Player, BukkitRunnable> tasks = new HashMap<Player, BukkitRunnable>();
    private final List<InventoryOpener> defaulters = Collections.singletonList(new ChestInventoryOpener());
    private final Collection<InventoryOpener> openers = new ArrayList<InventoryOpener>();

    public BasicSmartInventory(@NotNull Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    @NotNull
    public void init() {
        Arrays.asList(new InventoryClickListener(this), new InventoryOpenListener(this), new InventoryCloseListener(this), new PlayerQuitListener(this), new PluginDisableListener(this), new InventoryDragListener(this)).forEach(listener -> Bukkit.getPluginManager().registerEvents(listener, this.plugin()));
    }

    @Override
    @NotNull
    public Plugin plugin() {
        return this.plugin;
    }

    @Override
    @NotNull
    public Optional<InventoryOpener> findOpener(@NotNull InventoryType type) {
        return Stream.of(this.openers, this.defaulters).flatMap(Collection::stream).filter(opener -> opener.supports(type)).findAny();
    }

    @Override
    public void registerOpeners(InventoryOpener ... openers) {
        this.openers.addAll(Arrays.asList(openers));
    }

    @Override
    @NotNull
    public List<Player> getOpenedPlayers(@NotNull Page inv) {
        ArrayList<Player> list = new ArrayList<Player>();
        this.pages.forEach((player, playerInv) -> {
            if (inv.equals(playerInv)) {
                list.add((Player)player);
            }
        });
        return list;
    }

    @Override
    @NotNull
    public Optional<Page> getPage(@NotNull Player player) {
        return Optional.ofNullable(this.pages.get(player));
    }

    @Override
    public void notifyUpdate(@NotNull Player player) {
        this.getContents(player).ifPresent(InventoryContents::notifyUpdate);
    }

    @Override
    @NotNull
    public Optional<InventoryContents> getContents(@NotNull Player player) {
        return Optional.ofNullable(this.contents.get(player));
    }

    @Override
    @NotNull
    public Map<Player, Page> getPages() {
        return Collections.unmodifiableMap(this.pages);
    }

    @Override
    @NotNull
    public Map<Player, InventoryContents> getContents() {
        return Collections.unmodifiableMap(this.contents);
    }

    @Override
    public void removePage(@NotNull Player player) {
        this.pages.remove(player);
    }

    @Override
    public void removeContent(@NotNull Player player) {
        this.contents.remove(player);
    }

    @Override
    public void clearPages() {
        this.pages.clear();
    }

    @Override
    public void clearContents() {
        this.contents.clear();
    }

    @Override
    public void stopTick(Player player) {
        Optional.ofNullable(this.tasks.get(player)).ifPresent(runnable -> {
            Bukkit.getScheduler().cancelTask(runnable.getTaskId());
            this.tasks.remove(player);
        });
    }

    @Override
    public void setPage(@NotNull Player player, @NotNull Page page) {
        this.pages.put(player, page);
    }

    @Override
    public void setContents(@NotNull Player player, @NotNull InventoryContents contest) {
        this.contents.put(player, contest);
    }

    @Override
    public void tick(final @NotNull Player player, final @NotNull Page page) {
        BukkitRunnable task = new BukkitRunnable(){

            public void run() {
                page.provider().tick((InventoryContents)BasicSmartInventory.this.contents.get(player));
            }
        };
        if (page.async()) {
            task.runTaskTimer(this.plugin, 1L, page.tick());
        } else {
            task.runTaskTimerAsynchronously(this.plugin, 1L, page.tick());
        }
        this.tasks.put(player, task);
    }
}

