/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.smartinventory.icon;

import io.github.portlek.smartinventory.Icon;
import io.github.portlek.smartinventory.InventoryContents;
import io.github.portlek.smartinventory.Target;
import io.github.portlek.smartinventory.event.abs.IconEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class BasicIcon
implements Icon {
    private final Collection<Target<? extends IconEvent>> targets = new ArrayList<Target<? extends IconEvent>>();
    @NotNull
    private final ItemStack item;
    @NotNull
    private Predicate<InventoryContents> cansee = contents -> true;
    @NotNull
    private Predicate<InventoryContents> canuse = contents -> true;
    @NotNull
    private ItemStack fallback = new ItemStack(Material.AIR);

    public BasicIcon(@NotNull ItemStack item) {
        this.item = item;
    }

    @Override
    @NotNull
    public ItemStack calculateItem() {
        return this.item;
    }

    @Override
    @NotNull
    public ItemStack calculateItem(@NotNull InventoryContents contents) {
        ItemStack calculated = this.cansee.test(contents) ? this.item : this.fallback;
        return calculated;
    }

    @Override
    public <T extends IconEvent> void accept(@NotNull T event) {
        InventoryContents contents = event.contents();
        if (this.cansee.test(contents) && this.canuse.test(contents)) {
            this.targets.stream().filter(target -> target.getType().isAssignableFrom(event.getClass())).map(target -> target).forEach(target -> target.accept(event));
        }
    }

    @Override
    @NotNull
    public <T extends IconEvent> Icon target(@NotNull Target<T> target) {
        this.targets.add(target);
        return this;
    }

    @Override
    @NotNull
    public Icon targets(@NotNull Collection<Target<? extends IconEvent>> targets) {
        this.targets.addAll(targets);
        return this;
    }

    @Override
    @NotNull
    public Icon canSee(@NotNull Predicate<InventoryContents> predicate) {
        this.cansee = predicate;
        return this;
    }

    @Override
    @NotNull
    public Icon canUse(@NotNull Predicate<InventoryContents> predicate) {
        this.canuse = predicate;
        return this;
    }

    @Override
    @NotNull
    public Icon fallback(@NotNull ItemStack fallback) {
        this.fallback = fallback;
        return this;
    }

    @Override
    @NotNull
    public Icon clone(@NotNull ItemStack newitem) {
        return Icon.from(newitem).canSee(this.cansee).canUse(this.canuse).fallback(this.fallback).targets(this.targets);
    }
}

