/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.smartinventory.content;

import com.google.common.base.Preconditions;
import io.github.portlek.smartinventory.Icon;
import io.github.portlek.smartinventory.InventoryContents;
import io.github.portlek.smartinventory.Page;
import io.github.portlek.smartinventory.Pagination;
import io.github.portlek.smartinventory.SlotIterator;
import io.github.portlek.smartinventory.content.BasicPagination;
import io.github.portlek.smartinventory.content.BasicSlotIterator;
import io.github.portlek.smartinventory.util.Pattern;
import io.github.portlek.smartinventory.util.SlotPos;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class BasicInventoryContents
implements InventoryContents {
    private final Pagination pagination = new BasicPagination();
    private final Map<String, SlotIterator> iterators = new HashMap<String, SlotIterator>();
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final Set<SlotPos> editableSlots = new HashSet<SlotPos>();
    @NotNull
    private final Page page;
    @NotNull
    private final Player player;
    @NotNull
    private final Icon[][] contents;

    public BasicInventoryContents(@NotNull Page page, @NotNull Player plyr) {
        this.page = page;
        this.player = plyr;
        this.contents = new Icon[page.row()][page.column()];
    }

    @Override
    public Page page() {
        return this.page;
    }

    @Override
    public Pagination pagination() {
        return this.pagination;
    }

    @Override
    public Optional<SlotIterator> iterator(String id) {
        return Optional.ofNullable(this.iterators.get(id));
    }

    @Override
    public SlotIterator newIterator(String id, SlotIterator.Type type, int startRow, int startColumn) {
        BasicSlotIterator iterator = new BasicSlotIterator(this, type, startRow, startColumn);
        this.iterators.put(id, iterator);
        return iterator;
    }

    @Override
    public SlotIterator newIterator(SlotIterator.Type type, int startRow, int startColumn) {
        return new BasicSlotIterator(this, type, startRow, startColumn);
    }

    @Override
    public SlotIterator newIterator(String id, SlotIterator.Type type, SlotPos startPos) {
        return this.newIterator(id, type, startPos.getRow(), startPos.getColumn());
    }

    @Override
    public SlotIterator newIterator(SlotIterator.Type type, SlotPos startPos) {
        return this.newIterator(type, startPos.getRow(), startPos.getColumn());
    }

    @Override
    public Icon[][] all() {
        return (Icon[][])this.contents.clone();
    }

    @Override
    public List<SlotPos> slots() {
        ArrayList<SlotPos> position = new ArrayList<SlotPos>();
        for (int row = 0; row < this.contents.length; ++row) {
            for (int column = 0; column < this.contents[0].length; ++column) {
                position.add(SlotPos.of(row, column));
            }
        }
        return position;
    }

    @Override
    public Optional<SlotPos> firstEmpty() {
        for (int row = 0; row < this.contents.length; ++row) {
            for (int column = 0; column < this.contents[0].length; ++column) {
                if (this.get(row, column).isPresent()) continue;
                return Optional.of(new SlotPos(row, column));
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<Icon> get(int index) {
        int count = this.page.column();
        return this.get(index / count, index % count);
    }

    @Override
    public Optional<Icon> get(int row, int column) {
        if (row < 0 || row >= this.contents.length) {
            return Optional.empty();
        }
        if (column < 0 || column >= this.contents[row].length) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.contents[row][column]);
    }

    @Override
    public Optional<Icon> get(SlotPos pos) {
        return this.get(pos.getRow(), pos.getColumn());
    }

    @Override
    public InventoryContents set(int index, Icon item) {
        int columnCount = this.page.column();
        return this.set(index / columnCount, index % columnCount, item);
    }

    @Override
    public InventoryContents set(int row, int column, Icon item) {
        if (row < 0 || row >= this.contents.length) {
            return this;
        }
        if (column < 0 || column >= this.contents[row].length) {
            return this;
        }
        this.contents[row][column] = item;
        if (item == null) {
            this.update(row, column, null);
        } else {
            this.update(row, column, item.calculateItem(this));
        }
        return this;
    }

    @Override
    public InventoryContents set(SlotPos slotPos, Icon item) {
        return this.set(slotPos.getRow(), slotPos.getColumn(), item);
    }

    @Override
    public InventoryContents add(Icon item) {
        for (int row = 0; row < this.contents.length; ++row) {
            for (int column = 0; column < this.contents[0].length; ++column) {
                if (this.contents[row][column] != null) continue;
                this.set(row, column, item);
                return this;
            }
        }
        return this;
    }

    @Override
    public Optional<SlotPos> findItem(ItemStack itemStack) {
        for (int row = 0; row < this.contents.length; ++row) {
            for (int column = 0; column < this.contents[0].length; ++column) {
                Icon item = this.contents[row][column];
                if (item == null || !itemStack.isSimilar(item.calculateItem(this))) continue;
                return Optional.of(SlotPos.of(row, column));
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<SlotPos> findItem(Icon clickableItem) {
        return this.findItem(clickableItem.calculateItem(this));
    }

    @Override
    public void removeFirst(ItemStack item) {
        Preconditions.checkNotNull((Object)item, (Object)"The itemstack to remove cannot be null");
        this.findItem(item).ifPresent(slotPos -> this.set((SlotPos)slotPos, null));
    }

    @Override
    public void removeFirst(Icon item) {
        Preconditions.checkNotNull((Object)item, (Object)"The clickableitem to remove cannot be null");
        this.removeFirst(item.calculateItem());
    }

    @Override
    public void removeAmount(ItemStack item, int amount) {
        Preconditions.checkNotNull((Object)item, (Object)"The itemstack to remove cannot be null");
        for (int row = 0; row < this.contents.length; ++row) {
            for (int column = 0; column < this.contents[row].length; ++column) {
                Icon icon = this.contents[row][column];
                if (icon == null || !item.isSimilar(icon.calculateItem())) continue;
                ItemStack foundStack = icon.calculateItem();
                if (foundStack.getAmount() <= amount) {
                    this.set(row, column, null);
                    if ((amount -= foundStack.getAmount()) != 0) continue;
                    return;
                }
                if (foundStack.getAmount() <= amount) continue;
                ItemStack clonedStack = foundStack.clone();
                clonedStack.setAmount(clonedStack.getAmount() - amount);
                Icon clonedIcon = icon.clone(clonedStack);
                this.set(row, column, clonedIcon);
                return;
            }
        }
    }

    @Override
    public void removeAmount(Icon item, int amount) {
        Preconditions.checkNotNull((Object)item, (Object)"The clickableitem to remove cannot be null");
        this.removeAmount(item.calculateItem(), amount);
    }

    @Override
    public void removeAll(ItemStack item) {
        Preconditions.checkNotNull((Object)item, (Object)"The itemstack to remove cannot be null");
        for (int row = 0; row < this.contents.length; ++row) {
            for (int column = 0; column < this.contents[row].length; ++column) {
                if (this.contents[row][column] == null || !item.isSimilar(this.contents[row][column].calculateItem())) continue;
                this.set(row, column, null);
            }
        }
    }

    @Override
    public void removeAll(Icon item) {
        Preconditions.checkNotNull((Object)item, (Object)"The clickableitem to remove cannot be null");
        this.removeAll(item.calculateItem());
    }

    @Override
    public InventoryContents fill(Icon item) {
        for (int row = 0; row < this.contents.length; ++row) {
            for (int column = 0; column < this.contents[row].length; ++column) {
                this.set(row, column, item);
            }
        }
        return this;
    }

    @Override
    public InventoryContents fillRow(int row, Icon item) {
        if (row < 0 || row >= this.contents.length) {
            return this;
        }
        for (int column = 0; column < this.contents[row].length; ++column) {
            this.set(row, column, item);
        }
        return this;
    }

    @Override
    public InventoryContents fillColumn(int column, Icon item) {
        if (column < 0 || column >= this.contents[0].length) {
            return this;
        }
        for (int row = 0; row < this.contents.length; ++row) {
            this.set(row, column, item);
        }
        return this;
    }

    @Override
    public InventoryContents fillBorders(Icon item) {
        this.fillRect(0, 0, this.page.row() - 1, this.page.column() - 1, item);
        return this;
    }

    @Override
    public InventoryContents fillRect(int fromIndex, int toIndex, Icon item) {
        int count = this.page.column();
        return this.fillRect(fromIndex / count, fromIndex % count, toIndex / count, toIndex % count, item);
    }

    @Override
    public InventoryContents fillRect(int fromRow, int fromColumn, int toRow, int toColumn, Icon item) {
        for (int row = fromRow; row <= toRow; ++row) {
            for (int column = fromColumn; column <= toColumn; ++column) {
                if (row != fromRow && row != toRow && column != fromColumn && column != toColumn) continue;
                this.set(row, column, item);
            }
        }
        return this;
    }

    @Override
    public InventoryContents fillRect(SlotPos fromPos, SlotPos toPos, Icon item) {
        return this.fillRect(fromPos.getRow(), fromPos.getColumn(), toPos.getRow(), toPos.getColumn(), item);
    }

    @Override
    public InventoryContents fillSquare(int fromIndex, int toIndex, Icon item) {
        int count = this.page.column();
        return this.fillSquare(fromIndex / count, fromIndex % count, toIndex / count, toIndex % count, item);
    }

    @Override
    public InventoryContents fillSquare(int fromRow, int fromColumn, int toRow, int toColumn, Icon item) {
        Preconditions.checkArgument((fromRow < toRow ? 1 : 0) != 0, (Object)"The start row needs to be lower than the end row");
        Preconditions.checkArgument((fromColumn < toColumn ? 1 : 0) != 0, (Object)"The start column needs to be lower than the end column");
        for (int row = fromRow; row <= toRow; ++row) {
            for (int column = fromColumn; column <= toColumn; ++column) {
                this.set(row, column, item);
            }
        }
        return this;
    }

    @Override
    public InventoryContents fillSquare(SlotPos fromPos, SlotPos toPos, Icon item) {
        return this.fillSquare(fromPos.getRow(), fromPos.getColumn(), toPos.getRow(), toPos.getColumn(), item);
    }

    @Override
    public InventoryContents fillPattern(Pattern<Icon> pattern) {
        return this.fillPattern(pattern, 0, 0);
    }

    @Override
    public InventoryContents fillPattern(Pattern<Icon> pattern, int startIndex) {
        int count = this.page.column();
        return this.fillPattern(pattern, startIndex / count, startIndex % count);
    }

    @Override
    public InventoryContents fillPattern(Pattern<Icon> pattern, int startRow, int startColumn) {
        for (int row = 0; row < pattern.getRowCount(); ++row) {
            for (int column = 0; column < pattern.getColumnCount(); ++column) {
                Icon item = pattern.getObject(row, column);
                if (item == null) continue;
                this.set(startRow + row, startColumn + column, item);
            }
        }
        return this;
    }

    @Override
    public InventoryContents fillPattern(Pattern<Icon> pattern, SlotPos startPos) {
        return this.fillPattern(pattern, startPos.getRow(), startPos.getColumn());
    }

    @Override
    public InventoryContents fillPatternRepeating(Pattern<Icon> pattern) {
        return this.fillPatternRepeating(pattern, 0, 0, -1, -1);
    }

    @Override
    public InventoryContents fillPatternRepeating(Pattern<Icon> pattern, int startIndex, int endIndex) {
        boolean maxSize;
        int columnCount = this.page.column();
        boolean bl = maxSize = endIndex < 0;
        if (maxSize) {
            return this.fillPatternRepeating(pattern, startIndex / columnCount, startIndex % columnCount, -1, -1);
        }
        return this.fillPatternRepeating(pattern, startIndex / columnCount, startIndex % columnCount, endIndex / columnCount, endIndex % columnCount);
    }

    @Override
    public InventoryContents fillPatternRepeating(Pattern<Icon> pattern, int startRow, int startColumn, int endRow, int endColumn) {
        Preconditions.checkArgument((boolean)pattern.isWrapAround(), (Object)"To fill in a repeating pattern wrapAround needs to be enabled for the pattern to work!");
        if (endRow < 0) {
            endRow = this.page.row();
        }
        if (endColumn < 0) {
            endColumn = this.page.column();
        }
        Preconditions.checkArgument((startRow < endRow ? 1 : 0) != 0, (Object)"The start row needs to be lower than the end row");
        Preconditions.checkArgument((startColumn < endColumn ? 1 : 0) != 0, (Object)"The start column needs to be lower than the end column");
        int rowDelta = endRow - startRow;
        int columnDelta = endColumn - startColumn;
        for (int row = 0; row <= rowDelta; ++row) {
            for (int column = 0; column <= columnDelta; ++column) {
                Icon item = pattern.getObject(row, column);
                if (item == null) continue;
                this.set(startRow + row, startColumn + column, item);
            }
        }
        return this;
    }

    @Override
    public InventoryContents fillPatternRepeating(Pattern<Icon> pattern, SlotPos startPos, SlotPos endPos) {
        return this.fillPatternRepeating(pattern, startPos.getRow(), startPos.getColumn(), endPos.getRow(), endPos.getColumn());
    }

    @Override
    public <T> T property(String name) {
        return (T)this.properties.get(name);
    }

    @Override
    public <T> T property(String name, T def) {
        if (this.properties.containsKey(name)) {
            return (T)this.properties.get(name);
        }
        return def;
    }

    @Override
    public InventoryContents setProperty(String name, Object value) {
        this.properties.put(name, value);
        return this;
    }

    @Override
    public void setEditable(SlotPos slot, boolean editable) {
        if (editable) {
            this.editableSlots.add(slot);
        } else {
            this.editableSlots.remove(slot);
        }
    }

    @Override
    public boolean isEditable(SlotPos slot) {
        return this.editableSlots.contains(slot);
    }

    @Override
    @NotNull
    public Player player() {
        return this.player;
    }

    @Override
    @NotNull
    public Inventory getBottomInventory() {
        return this.player.getOpenInventory().getBottomInventory();
    }

    @Override
    @NotNull
    public Inventory getTopInventory() {
        return this.player.getOpenInventory().getTopInventory();
    }

    @Override
    public void notifyUpdate() {
        this.page.notifyUpdate(this);
    }

    private void update(int row, int column, ItemStack item) {
        if (!this.page.inventory().getOpenedPlayers(this.page).contains(this.player)) {
            return;
        }
        Inventory inv = this.getTopInventory();
        inv.setItem(this.page.column() * row + column, item);
    }
}

