/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.smartinventory;

import io.github.portlek.smartinventory.InventoryContents;
import io.github.portlek.smartinventory.InventoryProvided;
import io.github.portlek.smartinventory.Requirement;
import io.github.portlek.smartinventory.SmartInventory;
import io.github.portlek.smartinventory.Target;
import io.github.portlek.smartinventory.event.abs.CloseEvent;
import io.github.portlek.smartinventory.event.abs.OpenEvent;
import io.github.portlek.smartinventory.event.abs.PageEvent;
import io.github.portlek.smartinventory.page.BasicPage;
import io.github.portlek.smartinventory.target.BasicTarget;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;

public interface Page {
    public static Page build(@NotNull SmartInventory inventory, @NotNull InventoryProvided provided) {
        return new BasicPage(inventory, provided);
    }

    public void notifyUpdate(@NotNull InventoryContents var1);

    public <T extends PageEvent> void accept(@NotNull T var1);

    @NotNull
    public InventoryProvided provider();

    @NotNull
    public SmartInventory inventory();

    public long tick();

    @NotNull
    public Page tick(long var1);

    public boolean async();

    @NotNull
    public Page async(boolean var1);

    public int row();

    @NotNull
    public Page row(int var1);

    public int column();

    @NotNull
    public Page column(int var1);

    @NotNull
    public String title();

    @NotNull
    public Page title(@NotNull String var1);

    @NotNull
    default public Page whenclose(@NotNull Consumer<CloseEvent> consumer) {
        return this.whenclose(consumer, new Requirement[0]);
    }

    @NotNull
    default public Page whenclose(@NotNull Consumer<CloseEvent> consumer, Requirement<CloseEvent> ... requirements) {
        return this.target(CloseEvent.class, consumer, requirements);
    }

    @NotNull
    default public Page whenopen(@NotNull Consumer<OpenEvent> consumer) {
        return this.whenopen(consumer, new Requirement[0]);
    }

    @NotNull
    default public Page whenopen(@NotNull Consumer<OpenEvent> consumer, Requirement<OpenEvent> ... requirements) {
        return this.target(OpenEvent.class, consumer, requirements);
    }

    @NotNull
    default public <T extends PageEvent> Page target(@NotNull Class<T> clazz, @NotNull Consumer<T> consumer, Requirement<T> ... requirements) {
        return this.target(new BasicTarget<T>(clazz, consumer, requirements));
    }

    @NotNull
    public <T extends PageEvent> Page target(@NotNull Target<T> var1);

    @NotNull
    public Page canOpen(@NotNull Predicate<OpenEvent> var1);

    @NotNull
    public Page canClose(@NotNull Predicate<CloseEvent> var1);

    public boolean canOpen(@NotNull OpenEvent var1);

    public boolean canClose(@NotNull CloseEvent var1);

    public boolean checkBounds(int var1, int var2);

    @NotNull
    default public Inventory open(@NotNull Player player) {
        return this.open(player, 0);
    }

    @NotNull
    default public Inventory open(@NotNull Player player, int page) {
        return this.open(player, page, Collections.emptyMap());
    }

    @NotNull
    default public Inventory open(@NotNull Player player, @NotNull Map<String, Object> properties) {
        return this.open(player, 0, properties);
    }

    @NotNull
    public Inventory open(@NotNull Player var1, int var2, @NotNull Map<String, Object> var3);

    public void close(@NotNull Player var1);
}

