/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.bukkititembuilder;

import com.cryptomorin.xseries.XEnchantment;
import com.cryptomorin.xseries.XMaterial;
import com.google.common.collect.Multimap;
import io.github.bananapuncher714.nbteditor.NBTEditor;
import io.github.portlek.bukkititembuilder.Buildable;
import io.github.portlek.bukkititembuilder.util.ColorUtil;
import io.github.portlek.bukkitversion.BukkitVersion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.material.MaterialData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Builder<X extends Builder<X, T>, T extends ItemMeta>
implements Buildable<X, T> {
    public static final int VERSION = new BukkitVersion().minor();
    @NotNull
    private final T itemMeta;
    @NotNull
    private ItemStack itemStack;

    @NotNull
    public final X addAttributeModifier(@NotNull Attribute attribute, @NotNull AttributeModifier modifier) {
        if (VERSION < 14) {
            return (X)((Builder)this.self());
        }
        return (X)this.update(itemMeta -> itemMeta.addAttributeModifier(attribute, modifier));
    }

    @NotNull
    public final X addAttributeModifier(@NotNull Multimap<Attribute, AttributeModifier> map) {
        if (VERSION < 14) {
            return (X)((Builder)this.self());
        }
        return (X)this.update(itemMeta -> itemMeta.setAttributeModifiers(map));
    }

    @NotNull
    public final X addCustomData(@NotNull Object value, Object ... keys) {
        NBTEditor.NBTCompound itemNBTTag = NBTEditor.getNBTCompound(this.itemStack, new Object[0]);
        itemNBTTag.set(value, "tag", keys);
        return (X)this.setItemStack(NBTEditor.getItemFromTag(itemNBTTag));
    }

    @NotNull
    public final X addEnchantments(String ... enchantments) {
        for (String enchantmentString : enchantments) {
            String enchantment;
            String[] split = enchantmentString.split(":");
            AtomicInteger level = new AtomicInteger();
            if (split.length == 1) {
                enchantment = split[0];
                level.set(1);
            } else {
                enchantment = split[0];
                try {
                    level.set(Integer.parseInt(split[1]));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            XEnchantment.matchXEnchantment(enchantment).ifPresent(xEnchantment -> this.addEnchantments((XEnchantment)((Object)xEnchantment), level.get()));
        }
        return (X)((Builder)this.self());
    }

    @NotNull
    public final X addEnchantments(@NotNull XEnchantment enchantment, int level) {
        return (X)Optional.ofNullable(enchantment.parseEnchantment()).map(value -> this.addEnchantments((Enchantment)value, level)).orElse((Builder)this.self());
    }

    @NotNull
    public final X addEnchantments(final @NotNull Enchantment enchantment, final int level) {
        return this.addEnchantments((Map<Enchantment, Integer>)new HashMap<Enchantment, Integer>(){
            {
                this.put(enchantment, level);
            }
        });
    }

    @NotNull
    public final X addEnchantments(@NotNull Map<Enchantment, Integer> enchantments) {
        this.itemStack.addUnsafeEnchantments(enchantments);
        return (X)((Builder)this.self());
    }

    @NotNull
    public final X addFlag(ItemFlag ... flags) {
        return (X)this.update(itemMeta -> itemMeta.addItemFlags(flags));
    }

    @NotNull
    public final X addGlowEffect(@NotNull Enchantment enchantment, int level) {
        this.addFlag(ItemFlag.HIDE_ENCHANTS);
        return this.addEnchantments(enchantment, level);
    }

    @NotNull
    public final X addGlowEffect(@NotNull Enchantment enchantment) {
        return this.addGlowEffect(enchantment, 1);
    }

    @NotNull
    public final X addGlowEffect() {
        return (X)Optional.ofNullable(XMaterial.BOW.parseMaterial()).map(material -> this.addGlowEffect(this.itemStack.getType() != material ? Enchantment.ARROW_INFINITE : Enchantment.LUCK)).orElse((Builder)this.self());
    }

    @NotNull
    public final X addLore(String ... lore) {
        return this.addLore(true, lore);
    }

    @NotNull
    public final X addLore(boolean colored, String ... lore) {
        return this.addLore(List.of(lore), colored);
    }

    @NotNull
    public final X addLore(@NotNull List<String> lore) {
        return this.addLore(lore, true);
    }

    @NotNull
    public final X addLore(@NotNull List<String> lore, boolean colored) {
        return (X)this.update(itemMeta -> {
            List join = Optional.ofNullable(itemMeta.getLore()).orElse(new ArrayList());
            join.addAll(colored ? ColorUtil.colored((Collection<String>)lore) : lore);
            itemMeta.setLore(join);
        });
    }

    @NotNull
    public final X removeAttributeModifier(@NotNull Attribute attribute) {
        if (VERSION < 14) {
            return (X)((Builder)this.self());
        }
        return (X)this.update(itemMeta -> itemMeta.removeAttributeModifier(attribute));
    }

    @NotNull
    public final X removeAttributeModifier(@NotNull EquipmentSlot slot) {
        if (VERSION < 14) {
            return (X)((Builder)this.self());
        }
        return (X)this.update(itemMeta -> itemMeta.removeAttributeModifier(slot));
    }

    @NotNull
    public final X removeAttributeModifier(@NotNull Attribute attribute, @NotNull AttributeModifier modifier) {
        if (VERSION < 14) {
            return (X)((Builder)this.self());
        }
        return (X)this.update(itemMeta -> itemMeta.removeAttributeModifier(attribute, modifier));
    }

    @NotNull
    public final X removeFlag(ItemFlag ... flags) {
        return (X)this.update(itemMeta -> itemMeta.removeItemFlags(flags));
    }

    @NotNull
    public final X setAmount(int amount) {
        this.itemStack.setAmount(amount);
        return (X)((Builder)this.self());
    }

    @NotNull
    public final X setCustomModelData(@Nullable Integer data) {
        if (VERSION < 14) {
            return (X)((Builder)this.self());
        }
        return (X)this.update(itemMeta -> itemMeta.setCustomModelData(data));
    }

    @NotNull
    public final X setData(byte data) {
        return this.setData(this.itemStack.getType().getNewData(data));
    }

    @NotNull
    public final X setData(@NotNull MaterialData data) {
        this.itemStack.setData(data);
        return (X)((Builder)this.self());
    }

    @NotNull
    public final X setDurability(short durability) {
        this.itemStack.setDurability(durability);
        return (X)((Builder)this.self());
    }

    @Override
    @NotNull
    public final X setItemStack(@NotNull ItemStack itemStack) {
        this.itemStack = itemStack;
        return (X)((Builder)this.self());
    }

    @Override
    @NotNull
    public final X update(@NotNull Consumer<T> action) {
        action.accept(this.itemMeta);
        this.itemStack.setItemMeta(this.itemMeta);
        return (X)((Builder)this.self());
    }

    @NotNull
    public final X setLocalizedName(@Nullable String name) {
        if (VERSION < 12) {
            return (X)((Builder)this.self());
        }
        return (X)this.update(meta -> meta.setLocalizedName(name));
    }

    @NotNull
    public final X setLore(String ... lore) {
        return this.setLore(true, lore);
    }

    @NotNull
    public final X setLore(boolean colored, String ... lore) {
        return this.setLore(List.of(lore), colored);
    }

    @NotNull
    public final X setLore(@NotNull List<String> lore) {
        return this.setLore(lore, true);
    }

    @NotNull
    public final X setLore(@NotNull List<String> lore, boolean colored) {
        return (X)this.update(itemMeta -> itemMeta.setLore(colored ? ColorUtil.colored((Collection<String>)lore) : lore));
    }

    @NotNull
    public final X setMaterial(@NotNull Material material) {
        this.itemStack.setType(material);
        return (X)((Builder)this.self());
    }

    @NotNull
    public final X setName(@NotNull String name) {
        return this.setName(name, true);
    }

    @NotNull
    public final X setName(@NotNull String name, boolean colored) {
        return (X)this.update(itemMeta -> itemMeta.setDisplayName(colored ? ColorUtil.colored(name) : name));
    }

    @NotNull
    public final X setType(@NotNull Material material) {
        this.itemStack.setType(material);
        return (X)((Builder)this.self());
    }

    @NotNull
    public final X setUnbreakable(boolean unbreakable) {
        if (VERSION < 11) {
            return (X)this.setItemStack(NBTEditor.set(this.itemStack, unbreakable ? (byte)1 : 0, "Unbreakable"));
        }
        return (X)this.update(itemMeta -> itemMeta.setUnbreakable(unbreakable));
    }

    @NotNull
    public final X setVersion(int version) {
        if (VERSION < 14) {
            return (X)((Builder)this.self());
        }
        return (X)this.update(itemMeta -> itemMeta.setVersion(version));
    }

    protected Builder(@NotNull T itemMeta, @NotNull ItemStack itemStack) {
        if (itemMeta == null) {
            throw new NullPointerException("itemMeta is marked non-null but is null");
        }
        if (itemStack == null) {
            throw new NullPointerException("itemStack is marked non-null but is null");
        }
        this.itemMeta = itemMeta;
        this.itemStack = itemStack;
    }

    @NotNull
    public T getItemMeta() {
        return this.itemMeta;
    }

    @Override
    @NotNull
    public ItemStack getItemStack() {
        return this.itemStack;
    }
}

