/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.bukkititembuilder;

import com.cryptomorin.xseries.XMaterial;
import io.github.bananapuncher714.nbteditor.NBTEditor;
import io.github.portlek.bukkititembuilder.BannerItemBuilder;
import io.github.portlek.bukkititembuilder.BookItemBuilder;
import io.github.portlek.bukkititembuilder.Builder;
import io.github.portlek.bukkititembuilder.CrossbowItemBuilder;
import io.github.portlek.bukkititembuilder.FireworkItemBuilder;
import io.github.portlek.bukkititembuilder.MapItemBuilder;
import io.github.portlek.bukkititembuilder.SkullItemBuilder;
import java.util.Objects;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.CrossbowMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.NotNull;

public final class ItemStackBuilder
extends Builder<ItemStackBuilder, ItemMeta> {
    private ItemStackBuilder(@NotNull ItemStack item) {
        super(item, Objects.requireNonNull(item.getItemMeta(), "ItemMeta of " + item + " couldn't get!"));
    }

    @NotNull
    public static ItemStackBuilder from(@NotNull XMaterial material) {
        return ItemStackBuilder.from(Optional.ofNullable(material.parseMaterial()).orElseThrow(() -> new IllegalStateException("Material from the " + material.name() + " cannot be null!")));
    }

    @NotNull
    public static ItemStackBuilder from(@NotNull Material material) {
        return ItemStackBuilder.from(new ItemStack(material));
    }

    @NotNull
    public static ItemStackBuilder from(@NotNull ItemStack from) {
        return new ItemStackBuilder(from);
    }

    @NotNull
    public static ItemStackBuilder from(@NotNull String nbtjson) {
        return ItemStackBuilder.from(NBTEditor.getItemFromTag(NBTEditor.getNBTCompound(nbtjson)));
    }

    @Override
    @NotNull
    public ItemStackBuilder get() {
        return this;
    }

    @NotNull
    public CrossbowItemBuilder crossbow() {
        if (Builder.VERSION < 14) {
            throw new UnsupportedOperationException("The method called #crosbow() can only use 1.14 and later!");
        }
        return new CrossbowItemBuilder(this.itemStack(), this.validateMeta(CrossbowMeta.class));
    }

    @NotNull
    public MapItemBuilder map() {
        return new MapItemBuilder(this.itemStack(), this.validateMeta(MapMeta.class));
    }

    @NotNull
    public SkullItemBuilder skull() {
        return new SkullItemBuilder(this.itemStack(), this.validateMeta(SkullMeta.class));
    }

    @NotNull
    public BannerItemBuilder banner() {
        return new BannerItemBuilder(this.itemStack(), this.validateMeta(BannerMeta.class));
    }

    @NotNull
    public BookItemBuilder book() {
        return new BookItemBuilder(this.itemStack(), this.validateMeta(BookMeta.class));
    }

    @NotNull
    public FireworkItemBuilder firework() {
        return new FireworkItemBuilder(this.itemStack(), this.validateMeta(FireworkMeta.class));
    }

    @NotNull
    private <T extends ItemMeta> T validateMeta(@NotNull Class<T> meta) {
        if (!meta.isAssignableFrom(this.meta().getClass())) {
            throw new IllegalStateException(this.itemStack() + "'s meta is not a " + meta.getSimpleName() + '!');
        }
        return (T)this.meta();
    }
}

