/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.bukkititembuilder;

import com.cryptomorin.xseries.XEnchantment;
import com.cryptomorin.xseries.XMaterial;
import com.google.common.collect.Multimap;
import io.github.bananapuncher714.nbteditor.NBTEditor;
import io.github.portlek.bukkititembuilder.Buildable;
import io.github.portlek.bukkititembuilder.util.ColorUtil;
import io.github.portlek.bukkitversion.BukkitVersion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.material.MaterialData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Builder<X extends Builder<X, T>, T extends ItemMeta>
implements Buildable<X, T> {
    protected static final int VERSION = new BukkitVersion().minor();
    @NotNull
    private final T meta;
    @NotNull
    private ItemStack itemstack;

    protected Builder(@NotNull ItemStack itemstack, @NotNull T meta) {
        this.itemstack = itemstack;
        this.meta = meta;
    }

    @Override
    @NotNull
    public final ItemStack itemStack() {
        return this.itemstack;
    }

    @Override
    public final X itemStack(@NotNull ItemStack itemstack) {
        this.itemstack = itemstack;
        return (X)((Builder)this.get());
    }

    @Override
    @NotNull
    public final ItemMeta meta() {
        return this.meta;
    }

    @Override
    @NotNull
    public final X update(@NotNull Consumer<T> consumer) {
        consumer.accept(this.meta);
        this.itemstack.setItemMeta(this.meta);
        return (X)((Builder)this.get());
    }

    @NotNull
    public final X customData(@NotNull Object value, Object ... keys) {
        NBTEditor.NBTCompound itemNBTTag = NBTEditor.getNBTCompound(this.itemStack(), new Object[0]);
        itemNBTTag.set(value, "tag", keys);
        return (X)this.itemStack(NBTEditor.getItemFromTag(itemNBTTag));
    }

    @NotNull
    public final X material(@NotNull Material material) {
        this.itemstack.setType(material);
        return (X)((Builder)this.get());
    }

    @NotNull
    public final X localizedName(@Nullable String name) {
        if (VERSION < 12) {
            return (X)((Builder)this.get());
        }
        return (X)this.update(meta -> meta.setLocalizedName(name));
    }

    @NotNull
    public final X customModelData(@Nullable Integer data) {
        if (VERSION < 14) {
            return (X)((Builder)this.get());
        }
        return (X)this.update(itemMeta -> itemMeta.setCustomModelData(data));
    }

    @NotNull
    public final X unbreakable(Boolean unbreakable) {
        if (VERSION < 11) {
            return (X)this.itemStack(NBTEditor.set(this.itemStack(), unbreakable != false ? new Integer(1).byteValue() : new Integer(0).byteValue(), "Unbreakable"));
        }
        return (X)this.update(itemMeta -> itemMeta.setUnbreakable(unbreakable.booleanValue()));
    }

    @NotNull
    public final X glow() {
        return (X)Optional.ofNullable(XMaterial.BOW.parseMaterial()).map(material -> this.glow(this.itemStack().getType() != material ? Enchantment.ARROW_INFINITE : Enchantment.LUCK)).orElse((Builder)this.get());
    }

    @NotNull
    public final X glow(@NotNull Enchantment enchantment) {
        return this.glow(enchantment, 1);
    }

    @NotNull
    public final X glow(@NotNull Enchantment enchantment, int level) {
        this.flag(ItemFlag.HIDE_ENCHANTS);
        return this.enchantments(enchantment, level);
    }

    @NotNull
    public final X addAttributeModifier(@NotNull Attribute attribute, @NotNull AttributeModifier modifier) {
        if (VERSION < 14) {
            return (X)((Builder)this.get());
        }
        return (X)this.update(itemMeta -> itemMeta.addAttributeModifier(attribute, modifier));
    }

    @NotNull
    public final X addAttributeModifier(@NotNull Multimap<Attribute, AttributeModifier> map) {
        if (VERSION < 14) {
            return (X)((Builder)this.get());
        }
        return (X)this.update(itemMeta -> itemMeta.setAttributeModifiers(map));
    }

    @NotNull
    public final X removeAttributeModifier(@NotNull Attribute attribute) {
        if (VERSION < 14) {
            return (X)((Builder)this.get());
        }
        return (X)this.update(itemMeta -> itemMeta.removeAttributeModifier(attribute));
    }

    @NotNull
    public final X removeAttributeModifier(@NotNull EquipmentSlot slot) {
        if (VERSION < 14) {
            return (X)((Builder)this.get());
        }
        return (X)this.update(itemMeta -> itemMeta.removeAttributeModifier(slot));
    }

    @NotNull
    public final X removeAttributeModifier(@NotNull Attribute attribute, @NotNull AttributeModifier modifier) {
        if (VERSION < 14) {
            return (X)((Builder)this.get());
        }
        return (X)this.update(itemMeta -> itemMeta.removeAttributeModifier(attribute, modifier));
    }

    @NotNull
    public final X version(int version) {
        if (VERSION < 14) {
            return (X)((Builder)this.get());
        }
        return (X)this.update(itemMeta -> itemMeta.setVersion(version));
    }

    @NotNull
    public final X amount(int size) {
        this.itemStack().setAmount(size);
        return (X)((Builder)this.get());
    }

    @NotNull
    public final X flag(ItemFlag ... flags) {
        return (X)this.update(itemMeta -> itemMeta.addItemFlags(flags));
    }

    @NotNull
    public final X name(@NotNull String name) {
        return this.name(name, true);
    }

    @NotNull
    public final X name(@NotNull String name, boolean colored) {
        return (X)this.update(itemMeta -> itemMeta.setDisplayName(colored ? ColorUtil.colored(name) : name));
    }

    @NotNull
    public final X data(byte data) {
        return this.data(this.itemStack().getType().getNewData(data));
    }

    @NotNull
    public final X data(@NotNull MaterialData data) {
        this.itemStack().setData(data);
        return (X)((Builder)this.get());
    }

    @NotNull
    public final X damage(short damage) {
        this.itemStack().setDurability(damage);
        return (X)((Builder)this.get());
    }

    @NotNull
    public final X lore(String ... lore) {
        this.update(itemMeta -> itemMeta.setLore(new ArrayList()));
        return this.addLore(lore);
    }

    @NotNull
    public final X lore(@NotNull List<String> lore) {
        this.update(itemMeta -> itemMeta.setLore(new ArrayList()));
        return this.addLore(lore);
    }

    @NotNull
    public final X lore(@NotNull List<String> lore, boolean colored) {
        this.update(itemMeta -> itemMeta.setLore(new ArrayList()));
        return this.addLore(lore, colored);
    }

    @NotNull
    public final X addLore(String ... lore) {
        return this.addLore(Arrays.asList(lore), true);
    }

    @NotNull
    public final X addLore(@NotNull List<String> lore) {
        return this.addLore(lore, true);
    }

    @NotNull
    public final X addLore(@NotNull List<String> lore, boolean colored) {
        return (X)this.update(itemMeta -> {
            List join = Optional.ofNullable(itemMeta.getLore()).orElse(new ArrayList());
            join.addAll(colored ? ColorUtil.colored((Collection<String>)lore) : lore);
            itemMeta.setLore(join);
        });
    }

    @NotNull
    public final X enchantments(String ... enchantments) {
        Arrays.stream(enchantments).forEach(enchstring -> {
            String enchantment;
            String[] split = enchstring.split(":");
            AtomicInteger level = new AtomicInteger();
            if (split.length == 1) {
                enchantment = split[0];
                level.set(1);
            } else {
                enchantment = split[0];
                try {
                    level.set(Integer.parseInt(split[1]));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            XEnchantment.matchXEnchantment(enchantment).ifPresent(xEnchantment -> this.enchantments((XEnchantment)((Object)((Object)xEnchantment)), level.get()));
        });
        return (X)((Builder)this.get());
    }

    @NotNull
    public final X enchantments(@NotNull XEnchantment enchantment, int level) {
        return (X)Optional.ofNullable(enchantment.parseEnchantment()).map(value -> this.enchantments((Enchantment)value, level)).orElse((Builder)this.get());
    }

    @NotNull
    public final X enchantments(@NotNull Enchantment enchantment, int level) {
        HashMap<Enchantment, Integer> map = new HashMap<Enchantment, Integer>();
        map.put(enchantment, level);
        return this.enchantments(map);
    }

    @NotNull
    public final X enchantments(@NotNull Map<Enchantment, Integer> enchantments) {
        this.itemStack().addUnsafeEnchantments(enchantments);
        return (X)((Builder)this.get());
    }
}

