/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.bukkititembuilder;

import io.github.portlek.bukkititembuilder.Builder;
import java.util.Arrays;
import java.util.List;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BookItemBuilder
extends Builder<BookItemBuilder, BookMeta> {
    public BookItemBuilder(@NotNull ItemStack item, @NotNull BookMeta meta) {
        super(item, meta);
    }

    @NotNull
    public BookItemBuilder title(@Nullable String title) {
        return (BookItemBuilder)this.update(meta -> meta.setTitle(title));
    }

    @NotNull
    public BookItemBuilder generation(@Nullable BookMeta.Generation generation) {
        return (BookItemBuilder)this.update(meta -> meta.setGeneration(generation));
    }

    @NotNull
    public BookItemBuilder setPage(int page, @NotNull String text) {
        return (BookItemBuilder)this.update(meta -> meta.setPage(page, text));
    }

    @NotNull
    public BookItemBuilder addPages(String ... list) {
        return (BookItemBuilder)this.update(meta -> meta.addPage(list));
    }

    @NotNull
    public BookItemBuilder setPages(String ... list) {
        return this.setPages(Arrays.asList(list));
    }

    @NotNull
    public BookItemBuilder setPages(@NotNull List<String> list) {
        return (BookItemBuilder)this.update(meta -> meta.setPages(list));
    }

    @NotNull
    public BookItemBuilder author(@Nullable String author) {
        return (BookItemBuilder)this.update(meta -> meta.setAuthor(author));
    }

    @Override
    @NotNull
    public BookItemBuilder get() {
        return this;
    }
}

