/*
 * Decompiled with CFR 0.152.
 */
package feign.template;

import feign.template.UriUtils;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class UriUtilsTest {
    @Test
    public void pctEncode() {
        String queryParameterValue = "firstName=James;lastName=Bond;location=England&Britain?";
        Assertions.assertThat((String)UriUtils.encode((String)queryParameterValue, (Charset)StandardCharsets.UTF_8)).isEqualToIgnoringCase((CharSequence)"firstName%3DJames%3BlastName%3DBond%3Blocation%3DEngland%26Britain%3F");
    }

    @Test
    public void pctEncodeWithReservedCharacters() {
        String withReserved = "/api/user@host:port#section[a-z]/data";
        String encoded = UriUtils.encode((String)withReserved, (Charset)StandardCharsets.UTF_8, (boolean)true);
        Assertions.assertThat((String)encoded).isEqualTo("/api/user@host:port#section[a-z]/data");
    }
}

