/*
 * Decompiled with CFR 0.152.
 */
package feign.template;

import feign.Util;
import feign.template.UriTemplate;
import feign.template.UriUtils;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Test;

public class UriTemplateTest {
    @Test
    public void emptyRelativeTemplate() {
        String template = "/";
        UriTemplate uriTemplate = UriTemplate.create((String)template, (Charset)Util.UTF_8);
        Assertions.assertThat((String)uriTemplate.expand(Collections.emptyMap())).isEqualToIgnoringCase((CharSequence)"/");
    }

    @Test(expected=IllegalArgumentException.class)
    public void nullTemplate() {
        UriTemplate.create(null, (Charset)Util.UTF_8);
    }

    @Test
    public void emptyTemplate() {
        UriTemplate.create((String)"", (Charset)Util.UTF_8);
    }

    @Test
    public void simpleTemplate() {
        String template = "https://www.example.com/foo/{bar}";
        UriTemplate uriTemplate = UriTemplate.create((String)template, (Charset)Util.UTF_8);
        List uriTemplateVariables = uriTemplate.getVariables();
        ((ListAssert)Assertions.assertThat((List)uriTemplateVariables).contains((Object[])new String[]{"bar"})).hasSize(1);
        LinkedHashMap<String, String> variables = new LinkedHashMap<String, String>();
        variables.put("bar", "bar");
        String expandedTemplate = uriTemplate.expand(variables);
        Assertions.assertThat((String)expandedTemplate).isEqualToIgnoringCase((CharSequence)"https://www.example.com/foo/bar");
        Assertions.assertThat((URI)URI.create(expandedTemplate)).isNotNull();
    }

    @Test
    public void simpleTemplateMultipleExpressions() {
        String template = "https://www.example.com/{foo}/{bar}/details";
        UriTemplate uriTemplate = UriTemplate.create((String)template, (Charset)Util.UTF_8);
        List uriTemplateVariables = uriTemplate.getVariables();
        ((ListAssert)Assertions.assertThat((List)uriTemplateVariables).contains((Object[])new String[]{"foo", "bar"})).hasSize(2);
        LinkedHashMap<String, String> variables = new LinkedHashMap<String, String>();
        variables.put("foo", "first");
        variables.put("bar", "second");
        String expandedTemplate = uriTemplate.expand(variables);
        Assertions.assertThat((String)expandedTemplate).isEqualToIgnoringCase((CharSequence)"https://www.example.com/first/second/details");
        Assertions.assertThat((URI)URI.create(expandedTemplate)).isNotNull();
    }

    @Test
    public void simpleTemplateMultipleSequentialExpressions() {
        String template = "https://www.example.com/{foo}{bar}/{baz}/details";
        UriTemplate uriTemplate = UriTemplate.create((String)template, (Charset)Util.UTF_8);
        List uriTemplateVariables = uriTemplate.getVariables();
        ((ListAssert)Assertions.assertThat((List)uriTemplateVariables).contains((Object[])new String[]{"foo", "bar", "baz"})).hasSize(3);
        LinkedHashMap<String, String> variables = new LinkedHashMap<String, String>();
        variables.put("foo", "first");
        variables.put("bar", "second");
        variables.put("baz", "third");
        String expandedTemplate = uriTemplate.expand(variables);
        Assertions.assertThat((String)expandedTemplate).isEqualToIgnoringCase((CharSequence)"https://www.example.com/firstsecond/third/details");
        Assertions.assertThat((URI)URI.create(expandedTemplate)).isNotNull();
    }

    @Test
    public void simpleTemplateUnresolvedVariablesAreRemoved() {
        String template = "https://www.example.com/{foo}?name={name}";
        UriTemplate uriTemplate = UriTemplate.create((String)template, (Charset)Util.UTF_8);
        ((ListAssert)Assertions.assertThat((List)uriTemplate.getVariables()).contains((Object[])new String[]{"foo", "name"})).hasSize(2);
        LinkedHashMap<String, String> variables = new LinkedHashMap<String, String>();
        variables.put("name", "Albert");
        String expandedTemplate = uriTemplate.expand(variables);
        Assertions.assertThat((String)expandedTemplate).isEqualToIgnoringCase((CharSequence)"https://www.example.com/?name=Albert");
        Assertions.assertThat((URI)URI.create(expandedTemplate)).isNotNull();
    }

    @Test
    public void missingVariablesOnPathAreRemoved() {
        String template = "https://www.example.com/{foo}/items?name={name}";
        UriTemplate uriTemplate = UriTemplate.create((String)template, (Charset)Util.UTF_8);
        ((ListAssert)Assertions.assertThat((List)uriTemplate.getVariables()).contains((Object[])new String[]{"foo", "name"})).hasSize(2);
        LinkedHashMap<String, String> variables = new LinkedHashMap<String, String>();
        variables.put("name", "Albert");
        String expandedTemplate = uriTemplate.expand(variables);
        Assertions.assertThat((String)expandedTemplate).isEqualToIgnoringCase((CharSequence)"https://www.example.com//items?name=Albert");
        Assertions.assertThat((URI)URI.create(expandedTemplate)).isNotNull();
    }

    @Test
    public void simpleTemplateWithRegularExpressions() {
        String template = "https://www.example.com/{foo:[0-9]{4}}/{bar}";
        UriTemplate uriTemplate = UriTemplate.create((String)template, (Charset)Util.UTF_8);
        ((ListAssert)Assertions.assertThat((List)uriTemplate.getVariables()).contains((Object[])new String[]{"foo", "bar"})).hasSize(2);
        LinkedHashMap<String, Object> variables = new LinkedHashMap<String, Object>();
        variables.put("foo", 1234);
        variables.put("bar", "stuff");
        String expandedTemplate = uriTemplate.expand(variables);
        Assertions.assertThat((String)expandedTemplate).isEqualToIgnoringCase((CharSequence)"https://www.example.com/1234/stuff");
        Assertions.assertThat((URI)URI.create(expandedTemplate)).isNotNull();
    }

    @Test(expected=IllegalArgumentException.class)
    public void simpleTemplateWithRegularExpressionsValidation() {
        String template = "https://www.example.com/{foo:[0-9]{4}}/{bar}";
        UriTemplate uriTemplate = UriTemplate.create((String)template, (Charset)Util.UTF_8);
        ((ListAssert)Assertions.assertThat((List)uriTemplate.getVariables()).contains((Object[])new String[]{"foo", "bar"})).hasSize(2);
        LinkedHashMap<String, String> variables = new LinkedHashMap<String, String>();
        variables.put("foo", "abcd");
        variables.put("bar", "stuff");
        uriTemplate.expand(variables);
        Assertions.fail((String)"Should not be able to expand, pattern does not match");
    }

    @Test
    public void nestedExpressionsAreLiterals() {
        String template = "https://www.example.com/{foo{bar}}/{baz}";
        UriTemplate uriTemplate = UriTemplate.create((String)template, (Charset)Util.UTF_8);
        ((ListAssert)Assertions.assertThat((List)uriTemplate.getVariables()).contains((Object[])new String[]{"baz"})).hasSize(1);
        LinkedHashMap<String, String> variables = new LinkedHashMap<String, String>();
        variables.put("baz", "stuff");
        String expandedTemplate = uriTemplate.expand(variables);
        Assertions.assertThat((String)expandedTemplate).isEqualToIgnoringCase((CharSequence)"https://www.example.com/%7Bfoo%7Bbar%7D%7D/stuff");
        Assertions.assertThat((URI)URI.create(expandedTemplate)).isNotNull();
    }

    @Test
    public void literalTemplate() {
        String template = "https://www.example.com/do/stuff";
        UriTemplate uriTemplate = UriTemplate.create((String)template, (Charset)Util.UTF_8);
        String expandedTemplate = uriTemplate.expand(Collections.emptyMap());
        Assertions.assertThat((String)expandedTemplate).isEqualToIgnoringCase((CharSequence)template);
        Assertions.assertThat((URI)URI.create(expandedTemplate)).isNotNull();
    }

    @Test(expected=IllegalArgumentException.class)
    public void rejectEmptyExpressions() {
        String template = "https://www.example.com/{}/things";
        UriTemplate.create((String)template, (Charset)Util.UTF_8);
        Assertions.fail((String)"Should not accept empty expressions");
    }

    @Test
    public void testToString() {
        String template = "https://www.example.com/foo/{bar}/{baz:[0-9]}";
        UriTemplate uriTemplate = UriTemplate.create((String)template, (Charset)Util.UTF_8);
        Assertions.assertThat((String)uriTemplate.toString()).isEqualToIgnoringCase((CharSequence)template);
    }

    @Test
    public void encodeVariables() {
        String template = "https://www.example.com/{first}/{last}";
        UriTemplate uriTemplate = UriTemplate.create((String)template, (Charset)Util.UTF_8);
        LinkedHashMap<String, String> variables = new LinkedHashMap<String, String>();
        variables.put("first", "John Jacob");
        variables.put("last", "Jingleheimer Schmidt");
        String expandedTemplate = uriTemplate.expand(variables);
        Assertions.assertThat((String)expandedTemplate).isEqualToIgnoringCase((CharSequence)"https://www.example.com/John%20Jacob/Jingleheimer%20Schmidt");
    }

    @Test
    public void encodeLiterals() {
        String template = "https://www.example.com/A Team";
        UriTemplate uriTemplate = UriTemplate.create((String)template, (Charset)Util.UTF_8);
        String expandedTemplate = uriTemplate.expand(Collections.emptyMap());
        Assertions.assertThat((String)expandedTemplate).isEqualToIgnoringCase((CharSequence)"https://www.example.com/A%20Team");
    }

    @Test
    public void ensurePlusIsSupportedOnPath() {
        String template = "https://www.example.com/sam+adams/beer/{type}";
        UriTemplate uriTemplate = UriTemplate.create((String)template, (Charset)Util.UTF_8);
        String expanded = uriTemplate.expand(Collections.emptyMap());
        Assertions.assertThat((String)expanded).isEqualToIgnoringCase((CharSequence)"https://www.example.com/sam+adams/beer/");
    }

    @Test
    public void ensurePlusInEncodedAs2BOnQuery() {
        String template = "https://www.example.com/beer?type={type}";
        UriTemplate uriTemplate = UriTemplate.create((String)template, (Charset)Util.UTF_8);
        Map<String, String> parameters = Collections.singletonMap("type", "sam+adams");
        String expanded = uriTemplate.expand(parameters);
        Assertions.assertThat((String)expanded).isEqualToIgnoringCase((CharSequence)"https://www.example.com/beer?type=sam%2Badams");
    }

    @Test
    public void incompleteTemplateIsALiteral() {
        String template = "https://www.example.com/testing/foo}}";
        UriTemplate uriTemplate = UriTemplate.create((String)template, (Charset)Util.UTF_8);
        Assertions.assertThat((String)uriTemplate.expand(Collections.emptyMap())).isEqualToIgnoringCase((CharSequence)"https://www.example.com/testing/foo%7D%7D");
    }

    @Test(expected=IllegalArgumentException.class)
    public void substituteNullMap() {
        UriTemplate.create((String)"stuff", (Charset)Util.UTF_8).expand(null);
    }

    @Test
    public void skipAlreadyEncodedLiteral() {
        String template = "https://www.example.com/A%20Team";
        UriTemplate uriTemplate = UriTemplate.create((String)template, (Charset)Util.UTF_8);
        String expandedTemplate = uriTemplate.expand(Collections.emptyMap());
        Assertions.assertThat((String)expandedTemplate).isEqualToIgnoringCase((CharSequence)"https://www.example.com/A%20Team");
    }

    @Test
    public void skipAlreadyEncodedVariable() {
        String template = "https://www.example.com/testing/{foo}";
        UriTemplate uriTemplate = UriTemplate.create((String)template, (Charset)Util.UTF_8);
        String encodedVariable = UriUtils.encode((String)"Johnny Appleseed", (Charset)Util.UTF_8);
        LinkedHashMap<String, String> variables = new LinkedHashMap<String, String>();
        variables.put("foo", encodedVariable);
        Assertions.assertThat((String)uriTemplate.expand(variables)).isEqualToIgnoringCase((CharSequence)("https://www.example.com/testing/" + encodedVariable));
    }

    @Test
    public void skipSlashes() {
        String template = "https://www.example.com/{path}";
        UriTemplate uriTemplate = UriTemplate.create((String)template, (boolean)false, (Charset)Util.UTF_8);
        LinkedHashMap<String, String> variables = new LinkedHashMap<String, String>();
        variables.put("path", "me/you/first");
        String encoded = uriTemplate.expand(variables);
        Assertions.assertThat((String)encoded).isEqualToIgnoringCase((CharSequence)"https://www.example.com/me/you/first");
    }

    @Test
    public void encodeSlashes() {
        String template = "https://www.example.com/{path}";
        UriTemplate uriTemplate = UriTemplate.create((String)template, (Charset)Util.UTF_8);
        LinkedHashMap<String, String> variables = new LinkedHashMap<String, String>();
        variables.put("path", "me/you/first");
        String encoded = uriTemplate.expand(variables);
        Assertions.assertThat((String)encoded).isEqualToIgnoringCase((CharSequence)"https://www.example.com/me%2Fyou%2Ffirst");
    }

    @Test
    public void testLiteralTemplateWithQueryString() {
        String template = "https://api.example.com?wsdl";
        UriTemplate uriTemplate = UriTemplate.create((String)template, (Charset)Util.UTF_8);
        String expanded = uriTemplate.expand(Collections.emptyMap());
        Assertions.assertThat((String)expanded).isEqualToIgnoringCase((CharSequence)"https://api.example.com?wsdl");
    }

    @Test
    public void encodeReserved() {
        String template = "/get?url={url}";
        UriTemplate uriTemplate = UriTemplate.create((String)template, (Charset)Util.UTF_8);
        String expanded = uriTemplate.expand(Collections.singletonMap("url", "https://www.google.com"));
        Assertions.assertThat((String)expanded).isEqualToIgnoringCase((CharSequence)"/get?url=https%3A%2F%2Fwww.google.com");
    }
}

