/*
 * Decompiled with CFR 0.152.
 */
package feign.template;

import feign.CollectionFormat;
import feign.Util;
import feign.template.QueryTemplate;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class QueryTemplateTest {
    @Test
    public void templateToQueryString() {
        QueryTemplate template = QueryTemplate.create((String)"name", Arrays.asList("Bob", "James", "Jason"), (Charset)Util.UTF_8);
        Assertions.assertThat((String)template.toString()).isEqualToIgnoringCase((CharSequence)"name=Bob&name=James&name=Jason");
    }

    @Test
    public void expandEmptyCollection() {
        QueryTemplate template = QueryTemplate.create((String)"people", Collections.singletonList("{people}"), (Charset)Util.UTF_8);
        String expanded = template.expand(Collections.singletonMap("people", Collections.emptyList()));
        Assertions.assertThat((String)expanded).isEqualToIgnoringCase((CharSequence)"people=");
    }

    @Test
    public void expandCollection() {
        QueryTemplate template = QueryTemplate.create((String)"people", Collections.singletonList("{people}"), (Charset)Util.UTF_8);
        String expanded = template.expand(Collections.singletonMap("people", Arrays.asList("Bob", "James", "Jason")));
        Assertions.assertThat((String)expanded).isEqualToIgnoringCase((CharSequence)"people=Bob&people=James&people=Jason");
    }

    @Test
    public void expandCollectionWithBlanks() {
        QueryTemplate template = QueryTemplate.create((String)"people", Collections.singletonList("{people}"), (Charset)Util.UTF_8);
        String expanded = template.expand(Collections.singletonMap("people", Arrays.asList("", "Jason", "James")));
        Assertions.assertThat((String)expanded).isEqualToIgnoringCase((CharSequence)"people=&people=Jason&people=James");
    }

    @Test
    public void expandSingleValue() {
        QueryTemplate template = QueryTemplate.create((String)"name", Collections.singletonList("{value}"), (Charset)Util.UTF_8);
        String expanded = template.expand(Collections.singletonMap("value", "Magnum P.I."));
        Assertions.assertThat((String)expanded).isEqualToIgnoringCase((CharSequence)"name=Magnum%20P.I.");
    }

    @Test
    public void expandMultipleValues() {
        QueryTemplate template = QueryTemplate.create((String)"name", Arrays.asList("Bob", "James", "Jason"), (Charset)Util.UTF_8);
        String expanded = template.expand(Collections.emptyMap());
        Assertions.assertThat((String)expanded).isEqualToIgnoringCase((CharSequence)"name=Bob&name=James&name=Jason");
    }

    @Test
    public void unresolvedQuery() {
        QueryTemplate template = QueryTemplate.create((String)"name", Collections.singletonList("{value}"), (Charset)Util.UTF_8);
        String expanded = template.expand(Collections.emptyMap());
        Assertions.assertThat((String)expanded).isNullOrEmpty();
    }

    @Test
    public void unresolvedMultiValueQueryTemplates() {
        QueryTemplate template = QueryTemplate.create((String)"name", Arrays.asList("{bob}", "{james}", "{jason}"), (Charset)Util.UTF_8);
        String expanded = template.expand(Collections.emptyMap());
        Assertions.assertThat((String)expanded).isNullOrEmpty();
    }

    @Test
    public void explicitNullValuesAreRemoved() {
        QueryTemplate template = QueryTemplate.create((String)"name", Collections.singletonList("{value}"), (Charset)Util.UTF_8);
        String expanded = template.expand(Collections.singletonMap("value", null));
        Assertions.assertThat((String)expanded).isNullOrEmpty();
    }

    @Test
    public void emptyParameterRemains() {
        QueryTemplate template = QueryTemplate.create((String)"name", Collections.singletonList("{value}"), (Charset)Util.UTF_8);
        String expanded = template.expand(Collections.singletonMap("value", ""));
        Assertions.assertThat((String)expanded).isEqualToIgnoringCase((CharSequence)"name=");
    }

    @Test
    public void collectionFormat() {
        QueryTemplate template = QueryTemplate.create((String)"name", Arrays.asList("James", "Jason"), (Charset)Util.UTF_8, (CollectionFormat)CollectionFormat.CSV);
        String expanded = template.expand(Collections.emptyMap());
        Assertions.assertThat((String)expanded).isEqualToIgnoringCase((CharSequence)"name=James%2CJason");
    }

    @Test
    public void expandName() {
        QueryTemplate template = QueryTemplate.create((String)"{name}", Arrays.asList("James", "Jason"), (Charset)Util.UTF_8);
        String expanded = template.expand(Collections.singletonMap("name", "firsts"));
        Assertions.assertThat((String)expanded).isEqualToIgnoringCase((CharSequence)"firsts=James&firsts=Jason");
    }

    @Test
    public void expandPureParameter() {
        QueryTemplate template = QueryTemplate.create((String)"{name}", Collections.emptyList(), (Charset)Util.UTF_8);
        String expanded = template.expand(Collections.singletonMap("name", "firsts"));
        Assertions.assertThat((String)expanded).isEqualToIgnoringCase((CharSequence)"firsts");
    }

    @Test
    public void expandPureParameterWithSlash() {
        QueryTemplate template = QueryTemplate.create((String)"/path/{name}", Collections.emptyList(), (Charset)Util.UTF_8);
        String expanded = template.expand(Collections.singletonMap("name", "firsts"));
        Assertions.assertThat((String)expanded).isEqualToIgnoringCase((CharSequence)"/path/firsts");
    }

    @Test
    public void expandNameUnresolved() {
        QueryTemplate template = QueryTemplate.create((String)"{parameter}", Arrays.asList("James", "Jason"), (Charset)Util.UTF_8);
        String expanded = template.expand(Collections.singletonMap("name", "firsts"));
        Assertions.assertThat((String)expanded).isEqualToIgnoringCase((CharSequence)"%7Bparameter%7D=James&%7Bparameter%7D=Jason");
    }

    @Test
    public void expandSingleValueWithComma() {
        QueryTemplate template = QueryTemplate.create((String)"collection", Collections.singletonList("{collection}"), (Charset)Util.UTF_8);
        String expanded = template.expand(Collections.singletonMap("collection", "one,two,three"));
        Assertions.assertThat((String)expanded).isEqualToIgnoringCase((CharSequence)"collection=one%2Ctwo%2Cthree");
    }

    @Test
    public void expandSingleValueWithPipe() {
        QueryTemplate template = QueryTemplate.create((String)"collection", Collections.singletonList("{collection}"), (Charset)Util.UTF_8);
        String expanded = template.expand(Collections.singletonMap("collection", "one|two|three"));
        Assertions.assertThat((String)expanded).isEqualToIgnoringCase((CharSequence)"collection=one%7Ctwo%7Cthree");
    }

    @Test
    public void expandSingleValueWithSpace() {
        QueryTemplate template = QueryTemplate.create((String)"collection", Collections.singletonList("{collection}"), (Charset)Util.UTF_8);
        String expanded = template.expand(Collections.singletonMap("collection", "one two three"));
        Assertions.assertThat((String)expanded).isEqualToIgnoringCase((CharSequence)"collection=one%20two%20three");
    }

    @Test
    public void expandSingleValueWithTab() {
        QueryTemplate template = QueryTemplate.create((String)"collection", Collections.singletonList("{collection}"), (Charset)Util.UTF_8);
        String expanded = template.expand(Collections.singletonMap("collection", "one\ttwo\tthree"));
        Assertions.assertThat((String)expanded).isEqualToIgnoringCase((CharSequence)"collection=one%09two%09three");
    }

    @Test
    public void expandSingleValueWithJson() {
        QueryTemplate template = QueryTemplate.create((String)"json", Collections.singletonList("{json}"), (Charset)Util.UTF_8);
        String expanded = template.expand(Collections.singletonMap("json", "{\"name\":\"feign\",\"version\": \"10\"}"));
        Assertions.assertThat((String)expanded).isEqualToIgnoringCase((CharSequence)"json=%7B%22name%22%3A%22feign%22%2C%22version%22%3A%20%2210%22%7D");
    }

    @Test
    public void expandCollectionValueWithBrackets() {
        QueryTemplate template = QueryTemplate.create((String)"collection[]", Collections.singletonList("{collection[]}"), (Charset)Util.UTF_8, (CollectionFormat)CollectionFormat.CSV);
        String expanded = template.expand(Collections.singletonMap("collection[]", Arrays.asList("1", "2")));
        Assertions.assertThat((String)expanded).isEqualToIgnoringCase((CharSequence)"collection%5B%5D=1%2C2");
    }

    @Test
    public void expandCollectionValueWithDollar() {
        QueryTemplate template = QueryTemplate.create((String)"$collection", Collections.singletonList("{$collection}"), (Charset)Util.UTF_8, (CollectionFormat)CollectionFormat.CSV);
        String expanded = template.expand(Collections.singletonMap("$collection", Arrays.asList("1", "2")));
        Assertions.assertThat((String)expanded).isEqualToIgnoringCase((CharSequence)"%24collection=1%2C2");
    }
}

