/*
 * Decompiled with CFR 0.152.
 */
package feign.template;

import feign.template.HeaderTemplate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class HeaderTemplateTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test(expected=IllegalArgumentException.class)
    public void it_should_throw_exception_when_name_is_null() {
        HeaderTemplate.create(null, Collections.singletonList("test"));
        this.exception.expectMessage("name is required.");
    }

    @Test(expected=IllegalArgumentException.class)
    public void it_should_throw_exception_when_name_is_empty() {
        HeaderTemplate.create((String)"", Collections.singletonList("test"));
        this.exception.expectMessage("name is required.");
    }

    @Test(expected=IllegalArgumentException.class)
    public void it_should_throw_exception_when_value_is_null() {
        HeaderTemplate.create((String)"test", null);
        this.exception.expectMessage("values are required");
    }

    @Test
    public void it_should_return_name() {
        HeaderTemplate headerTemplate = HeaderTemplate.create((String)"test", Arrays.asList("test 1", "test 2"));
        Assert.assertEquals((Object)"test", (Object)headerTemplate.getName());
    }

    @Test
    public void it_should_return_expanded() {
        HeaderTemplate headerTemplate = HeaderTemplate.create((String)"hello", Arrays.asList("emre", "savci", "{name}", "{missing}"));
        Assert.assertEquals((Object)"emre, savci", (Object)headerTemplate.expand(Collections.emptyMap()));
        Assert.assertEquals((Object)"emre, savci, firsts", (Object)headerTemplate.expand(Collections.singletonMap("name", "firsts")));
    }

    @Test
    public void it_should_return_expanded_literals() {
        HeaderTemplate headerTemplate = HeaderTemplate.create((String)"hello", Arrays.asList("emre", "savci", "{replace_me}"));
        Assert.assertEquals((Object)"emre, savci, {}", (Object)headerTemplate.expand(Collections.singletonMap("replace_me", "{}")));
    }

    @Test
    public void create_should_preserve_order() {
        HeaderTemplate headerTemplateWithFirstOrdering = HeaderTemplate.create((String)"hello", Arrays.asList("test 1", "test 2"));
        Assert.assertThat(new ArrayList(headerTemplateWithFirstOrdering.getValues()), (Matcher)CoreMatchers.equalTo(Arrays.asList("test 1", "test 2")));
        HeaderTemplate headerTemplateWithSecondOrdering = HeaderTemplate.create((String)"hello", Arrays.asList("test 2", "test 1"));
        Assert.assertThat(new ArrayList(headerTemplateWithSecondOrdering.getValues()), (Matcher)CoreMatchers.equalTo(Arrays.asList("test 2", "test 1")));
    }

    @Test
    public void append_should_preserve_order() {
        HeaderTemplate headerTemplateWithFirstOrdering = HeaderTemplate.append((HeaderTemplate)HeaderTemplate.create((String)"hello", Collections.emptyList()), Arrays.asList("test 1", "test 2"));
        Assert.assertThat(new ArrayList(headerTemplateWithFirstOrdering.getValues()), (Matcher)CoreMatchers.equalTo(Arrays.asList("test 1", "test 2")));
        HeaderTemplate headerTemplateWithSecondOrdering = HeaderTemplate.append((HeaderTemplate)HeaderTemplate.create((String)"hello", Collections.emptyList()), Arrays.asList("test 2", "test 1"));
        Assert.assertThat(new ArrayList(headerTemplateWithSecondOrdering.getValues()), (Matcher)CoreMatchers.equalTo(Arrays.asList("test 2", "test 1")));
    }

    @Test
    public void it_should_support_http_date() {
        HeaderTemplate headerTemplate = HeaderTemplate.create((String)"Expires", Collections.singletonList("{expires}"));
        Assert.assertEquals((Object)headerTemplate.expand(Collections.singletonMap("expires", "Wed, 4 Jul 2001 12:08:56 -0700")), (Object)"Wed, 4 Jul 2001 12:08:56 -0700");
    }
}

