/*
 * Decompiled with CFR 0.152.
 */
package feign.stream;

import com.fasterxml.jackson.core.type.TypeReference;
import feign.Feign;
import feign.Request;
import feign.RequestLine;
import feign.Response;
import feign.Util;
import feign.codec.Decoder;
import feign.stream.StreamDecoder;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class StreamDecoderTest {
    private String carsJson = "[\n  {\n    \"name\": \"Megane\",\n    \"manufacturer\": \"Renault\"\n  },\n  {\n    \"name\": \"C4\",\n    \"manufacturer\": \"Citro\u00ebn\"\n  }\n]\n";

    @Test
    public void simpleStreamTest() {
        MockWebServer server = new MockWebServer();
        server.enqueue(new MockResponse().setBody("foo\nbar"));
        StreamInterface api = (StreamInterface)Feign.builder().decoder((Decoder)StreamDecoder.create((response, type) -> new BufferedReader(response.body().asReader(Util.UTF_8)).lines().iterator())).doNotCloseAfterDecode().target(StreamInterface.class, server.url("/").toString());
        try (Stream<String> stream = api.get();){
            Assertions.assertThat(stream.collect(Collectors.toList())).isEqualTo(Arrays.asList("foo", "bar"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldCloseIteratorWhenStreamClosed() throws IOException {
        Response response = Response.builder().status(200).reason("OK").headers(Collections.emptyMap()).request(Request.create((Request.HttpMethod)Request.HttpMethod.GET, (String)"/api", Collections.emptyMap(), null, (Charset)Util.UTF_8)).body("", Util.UTF_8).build();
        TestCloseableIterator it = new TestCloseableIterator();
        StreamDecoder decoder = new StreamDecoder((r, t) -> it);
        try (Stream stream = (Stream)decoder.decode(response, new TypeReference<Stream<String>>(){}.getType());){
            Assertions.assertThat(stream.collect(Collectors.toList())).hasSize(1);
            Assertions.assertThat((boolean)it.called).isTrue();
        }
        finally {
            Assertions.assertThat((boolean)it.closed).isTrue();
        }
    }

    static class TestCloseableIterator
    implements Iterator<String>,
    Closeable {
        boolean called;
        boolean closed;

        TestCloseableIterator() {
        }

        @Override
        public void close() {
            this.closed = true;
        }

        @Override
        public boolean hasNext() {
            return !this.called;
        }

        @Override
        public String next() {
            this.called = true;
            return "feign";
        }
    }

    static interface StreamInterface {
        @RequestLine(value="GET /")
        public Stream<String> get();

        @RequestLine(value="GET /cars")
        public Stream<Car> getCars();

        public static class Car {
            public String name;
            public String manufacturer;
        }
    }
}

