/*
 * Decompiled with CFR 0.152.
 */
package feign.querymap;

import feign.Param;
import feign.QueryMapEncoder;
import feign.querymap.FieldQueryMapEncoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class FieldQueryMapEncoderTest {
    @Rule
    public final ExpectedException thrown = ExpectedException.none();
    private final QueryMapEncoder encoder = new FieldQueryMapEncoder();

    @Test
    public void testDefaultEncoder_normalClassWithValues() {
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("foo", "fooz");
        expected.put("bar", "barz");
        NormalObject normalObject = new NormalObject("fooz", "barz");
        Map encodedMap = this.encoder.encode((Object)normalObject);
        Assert.assertEquals((String)"Unexpected encoded query map", expected, (Object)encodedMap);
    }

    @Test
    public void testDefaultEncoder_normalClassWithOutValues() {
        NormalObject normalObject = new NormalObject(null, null);
        Map encodedMap = this.encoder.encode((Object)normalObject);
        Assert.assertTrue((String)("Non-empty map generated from null getter: " + encodedMap), (boolean)encodedMap.isEmpty());
    }

    @Test
    public void testDefaultEncoder_withOverriddenParamName() {
        HashSet<String> expectedNames = new HashSet<String>();
        expectedNames.add("fooAlias");
        expectedNames.add("bar");
        NormalObjectWithOverriddenParamName normalObject = new NormalObjectWithOverriddenParamName("fooz", "barz");
        Map encodedMap = this.encoder.encode((Object)normalObject);
        Assert.assertEquals((String)"@Param ignored", expectedNames, encodedMap.keySet());
    }

    class NormalObjectWithOverriddenParamName {
        @Param(value="fooAlias")
        private final String foo;
        private final String bar;

        private NormalObjectWithOverriddenParamName(String foo, String bar) {
            this.foo = foo;
            this.bar = bar;
        }
    }

    class NormalObject {
        private final String foo;
        private final String bar;

        private NormalObject(String foo, String bar) {
            this.foo = foo;
            this.bar = bar;
        }
    }
}

