/*
 * Decompiled with CFR 0.152.
 */
package feign.querymap;

import feign.Param;
import feign.QueryMapEncoder;
import feign.querymap.BeanQueryMapEncoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class BeanQueryMapEncoderTest {
    @Rule
    public final ExpectedException thrown = ExpectedException.none();
    private final QueryMapEncoder encoder = new BeanQueryMapEncoder();

    @Test
    public void testDefaultEncoder_normalClassWithValues() {
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("foo", "fooz");
        expected.put("bar", "barz");
        expected.put("fooAppendBar", "foozbarz");
        NormalObject normalObject = new NormalObject("fooz", "barz");
        Map encodedMap = this.encoder.encode((Object)normalObject);
        Assert.assertEquals((String)"Unexpected encoded query map", expected, (Object)encodedMap);
    }

    @Test
    public void testDefaultEncoder_normalClassWithOutValues() {
        NormalObject normalObject = new NormalObject(null, null);
        Map encodedMap = this.encoder.encode((Object)normalObject);
        Assert.assertTrue((String)("Non-empty map generated from null getter: " + encodedMap), (boolean)encodedMap.isEmpty());
    }

    @Test
    public void testDefaultEncoder_haveSuperClass() {
        HashMap<String, Object> expected = new HashMap<String, Object>();
        expected.put("page", 1);
        expected.put("size", 10);
        expected.put("query", "queryString");
        SubClass subClass = new SubClass();
        subClass.setPage(1);
        subClass.setSize(10);
        subClass.setQuery("queryString");
        Map encodedMap = this.encoder.encode((Object)subClass);
        Assert.assertEquals((String)"Unexpected encoded query map", expected, (Object)encodedMap);
    }

    @Test
    public void testDefaultEncoder_withOverriddenParamName() {
        HashSet<String> expectedNames = new HashSet<String>();
        expectedNames.add("fooAlias");
        expectedNames.add("bar");
        NormalObjectWithOverriddenParamName normalObject = new NormalObjectWithOverriddenParamName("fooz", "barz");
        Map encodedMap = this.encoder.encode((Object)normalObject);
        Assert.assertEquals((String)"@Param ignored", expectedNames, encodedMap.keySet());
    }

    class SubClass
    extends SuperClass {
        private String query;

        SubClass() {
        }

        public String getQuery() {
            return this.query;
        }

        public void setQuery(String query) {
            this.query = query;
        }
    }

    class SuperClass {
        private int page;
        private int size;

        SuperClass() {
        }

        public int getPage() {
            return this.page;
        }

        public void setPage(int page) {
            this.page = page;
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int size) {
            this.size = size;
        }
    }

    class NormalObject {
        private String foo;
        private String bar;

        private NormalObject(String foo, String bar) {
            this.foo = foo;
            this.bar = bar;
        }

        public String getFoo() {
            return this.foo;
        }

        public String getBar() {
            return this.bar;
        }

        public String getFooAppendBar() {
            if (this.foo != null && this.bar != null) {
                return this.foo + this.bar;
            }
            return null;
        }
    }

    class NormalObjectWithOverriddenParamName {
        private String foo;
        private String bar;

        private NormalObjectWithOverriddenParamName(String foo, String bar) {
            this.foo = foo;
            this.bar = bar;
        }

        @Param(value="fooAlias")
        public String getFoo() {
            return this.foo;
        }

        public String getBar() {
            return this.bar;
        }
    }
}

