/*
 * Decompiled with CFR 0.152.
 */
package feign.optionals;

import feign.Feign;
import feign.RequestLine;
import feign.codec.Decoder;
import feign.optionals.OptionalDecoder;
import java.io.IOException;
import java.util.Optional;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class OptionalDecoderTests {
    @Test
    public void simple404OptionalTest() throws IOException, InterruptedException {
        MockWebServer server = new MockWebServer();
        server.enqueue(new MockResponse().setResponseCode(404));
        server.enqueue(new MockResponse().setBody("foo"));
        OptionalInterface api = (OptionalInterface)Feign.builder().decode404().decoder((Decoder)new OptionalDecoder((Decoder)new Decoder.Default())).target(OptionalInterface.class, server.url("/").toString());
        Assertions.assertThat((boolean)api.getAsOptional().isPresent()).isFalse();
        Assertions.assertThat((String)api.getAsOptional().get()).isEqualTo("foo");
    }

    @Test
    public void simple204OptionalTest() throws IOException, InterruptedException {
        MockWebServer server = new MockWebServer();
        server.enqueue(new MockResponse().setResponseCode(204));
        OptionalInterface api = (OptionalInterface)Feign.builder().decoder((Decoder)new OptionalDecoder((Decoder)new Decoder.Default())).target(OptionalInterface.class, server.url("/").toString());
        Assertions.assertThat((boolean)api.getAsOptional().isPresent()).isFalse();
    }

    @Test
    public void test200WithOptionalString() throws IOException, InterruptedException {
        MockWebServer server = new MockWebServer();
        server.enqueue(new MockResponse().setResponseCode(200).setBody("foo"));
        OptionalInterface api = (OptionalInterface)Feign.builder().decoder((Decoder)new OptionalDecoder((Decoder)new Decoder.Default())).target(OptionalInterface.class, server.url("/").toString());
        Optional<String> response = api.getAsOptional();
        Assertions.assertThat((boolean)response.isPresent()).isTrue();
        Assertions.assertThat(response).isEqualTo(Optional.of("foo"));
    }

    @Test
    public void test200WhenResponseBodyIsNull() throws IOException, InterruptedException {
        MockWebServer server = new MockWebServer();
        server.enqueue(new MockResponse().setResponseCode(200));
        OptionalInterface api = (OptionalInterface)Feign.builder().decoder((Decoder)new OptionalDecoder((response, type) -> null)).target(OptionalInterface.class, server.url("/").toString());
        Assertions.assertThat((boolean)api.getAsOptional().isPresent()).isFalse();
    }

    @Test
    public void test200WhenDecodingNoOptional() throws IOException, InterruptedException {
        MockWebServer server = new MockWebServer();
        server.enqueue(new MockResponse().setResponseCode(200).setBody("foo"));
        OptionalInterface api = (OptionalInterface)Feign.builder().decoder((Decoder)new OptionalDecoder((Decoder)new Decoder.Default())).target(OptionalInterface.class, server.url("/").toString());
        Assertions.assertThat((String)api.get()).isEqualTo("foo");
    }

    static interface OptionalInterface {
        @RequestLine(value="GET /")
        public Optional<String> getAsOptional();

        @RequestLine(value="GET /")
        public String get();
    }
}

